/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.function.Supplier;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.infinispan.InfinispanIdempotentRepository;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteUtil;
import org.apache.camel.util.function.Suppliers;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.BasicCache;

@ManagedResource(description="Infinispan Remote message id repository")
public class InfinispanRemoteIdempotentRepository
extends InfinispanIdempotentRepository {
    private final String cacheName;
    private final Supplier<RemoteCache<String, Boolean>> cache;
    private InfinispanRemoteConfiguration configuration;
    private InfinispanRemoteManager manager;

    public InfinispanRemoteIdempotentRepository(String cacheName) {
        this.cacheName = cacheName;
        this.cache = Suppliers.memorize(() -> InfinispanRemoteUtil.getCacheWithFlags(this.manager, cacheName, Flag.FORCE_RETURN_VALUE));
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration == null) {
            this.configuration = new InfinispanRemoteConfiguration();
        }
        this.manager = new InfinispanRemoteManager(this.configuration);
        this.manager.setCamelContext(this.getCamelContext());
        this.manager.start();
    }

    protected void doShutdown() throws Exception {
        this.manager.shutdown();
        super.doShutdown();
    }

    protected BasicCache<String, Boolean> getCache() {
        return (BasicCache)this.cache.get();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public InfinispanRemoteConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanRemoteConfiguration configuration) {
        this.configuration = configuration;
    }

    public InfinispanRemoteManager getManager() {
        return this.manager;
    }

    public void setManager(InfinispanRemoteManager manager) {
        this.manager = manager;
    }

    public RemoteCacheManager getCacheContainer() {
        return this.configuration != null ? this.configuration.getCacheContainer() : null;
    }

    public void setCacheContainer(RemoteCacheManager cacheContainer) {
        if (this.configuration == null) {
            this.configuration = new InfinispanRemoteConfiguration();
        }
        this.configuration.setCacheContainer(cacheContainer);
    }
}

