/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb2.data;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.component.influxdb2.data.Measurement;

public final class Measurements {
    private List<Measurement> measurements = new ArrayList<Measurement>();

    private Measurements() {
    }

    private Measurements(List<Measurement> measurements) {
        this.measurements = measurements;
    }

    public static Measurements create() {
        return new Measurements();
    }

    public static Measurements create(List<Measurement> measurements) {
        return new Measurements(measurements);
    }

    public static Measurements create(Measurement measurement) {
        return new Measurements().addMeasurement(measurement);
    }

    public static Measurements create(Object measurement) {
        return Measurements.create(Measurement.fromObject(measurement));
    }

    public List<Object> getInfluxMeasurements() {
        return this.measurements.stream().map(Measurement::getInfluxMeasurement).collect(Collectors.toList());
    }

    public Measurements setMeasurements(List<Measurement> measurements) {
        this.measurements = measurements;
        return this;
    }

    public Measurements addMeasurement(Measurement measurement) {
        this.measurements.add(measurement);
        return this;
    }

    public String toString() {
        return "Measurements{measurements=" + this.measurements + "}";
    }
}

