/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.irc.IrcChannel;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventAdapter;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrcProducer
extends DefaultProducer {
    public static final String[] COMMANDS = new String[]{"AWAY", "INVITE", "ISON", "JOIN", "KICK", "LIST", "NAMES", "PRIVMSG", "MODE", "NICK", "NOTICE", "PART", "PONG", "QUIT", "TOPIC", "WHO", "WHOIS", "WHOWAS", "USERHOST"};
    private static final Logger LOG = LoggerFactory.getLogger(IrcProducer.class);
    private transient IRCConnection connection;
    private IRCEventAdapter listener = new FilteredIRCEventAdapter();

    public IrcProducer(IrcEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public IrcEndpoint getEndpoint() {
        return (IrcEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String msg = (String)exchange.getIn().getBody(String.class);
        String sendTo = (String)exchange.getIn().getHeader("irc.sendTo", String.class);
        if (this.connection == null || !this.connection.isConnected()) {
            this.reconnect();
        }
        if (this.connection == null || !this.connection.isConnected()) {
            throw new RuntimeCamelException("Lost connection" + (String)(this.connection == null ? "" : " to " + this.connection.getHost()));
        }
        if (msg != null) {
            if (this.isMessageACommand(msg)) {
                LOG.debug("Sending command: {}", (Object)msg);
                this.connection.send(msg);
            } else if (sendTo != null) {
                LOG.debug("Sending to: {} message: {}", (Object)sendTo, (Object)msg);
                this.connection.doPrivmsg(sendTo, msg);
            } else {
                for (IrcChannel channel : this.getEndpoint().getConfiguration().getChannelList()) {
                    LOG.debug("Sending to: {} message: {}", (Object)channel, (Object)msg);
                    this.connection.doPrivmsg(channel.getName(), msg);
                }
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.reconnect();
    }

    protected void reconnect() {
        if (this.connection == null || this.connection.isConnected()) {
            this.connection = this.getEndpoint().getComponent().getIRCConnection(this.getEndpoint().getConfiguration());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reconnecting to {}:{}", (Object)this.getEndpoint().getConfiguration().getHostname(), (Object)this.getEndpoint().getConfiguration().getNickname());
            }
            this.getEndpoint().getComponent().closeConnection(this.connection);
            this.connection = this.getEndpoint().getComponent().getIRCConnection(this.getEndpoint().getConfiguration());
        }
        this.connection.addIRCEventListener((IRCEventListener)this.listener);
        LOG.debug("Sleeping for {} seconds before sending commands.", (Object)(this.getEndpoint().getConfiguration().getCommandTimeout() / 1000L));
        try {
            Thread.sleep(this.getEndpoint().getConfiguration().getCommandTimeout());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getEndpoint().joinChannels();
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            for (IrcChannel channel : this.getEndpoint().getConfiguration().getChannelList()) {
                LOG.debug("Parting: {}", (Object)channel);
                this.connection.doPart(channel.getName());
            }
            this.connection.removeIRCEventListener((IRCEventListener)this.listener);
        }
        super.doStop();
    }

    protected boolean isMessageACommand(String msg) {
        for (String command : COMMANDS) {
            if (!msg.startsWith(command)) continue;
            return true;
        }
        return false;
    }

    public IRCEventAdapter getListener() {
        return this.listener;
    }

    public void setListener(IRCEventAdapter listener) {
        this.listener = listener;
    }

    class FilteredIRCEventAdapter
    extends IRCEventAdapter {
        FilteredIRCEventAdapter() {
        }

        public void onKick(String channel, IRCUser user, String passiveNick, String msg) {
            if (passiveNick.equals(IrcProducer.this.connection.getNick()) && IrcProducer.this.getEndpoint().getConfiguration().isAutoRejoin()) {
                IrcProducer.this.getEndpoint().joinChannel(channel);
            }
        }

        public void onError(int num, String msg) {
            IrcProducer.this.getEndpoint().handleIrcError(num);
        }
    }
}

