/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ironmq;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ironmq.IronMQConfiguration;
import org.apache.camel.component.ironmq.IronMQEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ScheduledPollEndpoint;

@Component(value="ironmq")
public class IronMQComponent
extends DefaultComponent {
    public IronMQComponent(CamelContext context) {
        super(context);
    }

    public IronMQComponent() {
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        IronMQConfiguration ironMQConfiguration = new IronMQConfiguration();
        this.setProperties(ironMQConfiguration, parameters);
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Queue name must be specified.");
        }
        ironMQConfiguration.setQueueName(remaining);
        if (ironMQConfiguration.getClient() == null && (ironMQConfiguration.getProjectId() == null || ironMQConfiguration.getToken() == null)) {
            throw new IllegalArgumentException("Client or project and token must be specified.");
        }
        IronMQEndpoint endpoint = new IronMQEndpoint(uri, this, ironMQConfiguration);
        ((ScheduledPollEndpoint)endpoint).setConsumerProperties(parameters);
        return endpoint;
    }
}

