/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ironmq;

import io.iron.ironmq.Client;
import io.iron.ironmq.Cloud;
import java.net.MalformedURLException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ironmq.GsonUtil;
import org.apache.camel.component.ironmq.IronMQComponent;
import org.apache.camel.component.ironmq.IronMQConfiguration;
import org.apache.camel.component.ironmq.IronMQConsumer;
import org.apache.camel.component.ironmq.IronMQProducer;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultScheduledPollConsumerScheduler;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.17.0", scheme="ironmq", syntax="ironmq:queueName", title="IronMQ", label="cloud,messaging")
public class IronMQEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private IronMQConfiguration configuration;
    private Client client;

    public IronMQEndpoint(String uri, IronMQComponent component, IronMQConfiguration ironMQConfiguration) {
        super(uri, (Component)component);
        this.configuration = ironMQConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new IronMQProducer(this, this.getClient().queue(this.configuration.getQueueName()));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        IronMQConsumer ironMQConsumer = new IronMQConsumer((Endpoint)this, processor, this.getClient().queue(this.configuration.getQueueName()));
        this.configureConsumer((Consumer)ironMQConsumer);
        ironMQConsumer.setMaxMessagesPerPoll(this.configuration.getMaxMessagesPerPoll());
        DefaultScheduledPollConsumerScheduler scheduler = new DefaultScheduledPollConsumerScheduler();
        scheduler.setConcurrentTasks(this.configuration.getConcurrentConsumers());
        ironMQConsumer.setScheduler((ScheduledPollConsumerScheduler)scheduler);
        return ironMQConsumer;
    }

    public Exchange createExchange(io.iron.ironmq.Message msg) {
        return this.createExchange(this.getExchangePattern(), msg);
    }

    private Exchange createExchange(ExchangePattern pattern, io.iron.ironmq.Message msg) {
        Exchange exchange = super.createExchange(pattern);
        Message message = exchange.getIn();
        if (this.configuration.isPreserveHeaders()) {
            GsonUtil.copyFrom(msg, message);
        } else {
            message.setBody((Object)msg.getBody());
        }
        message.setHeader("CamelIronMQMessageId", (Object)msg.getId());
        message.setHeader("CamelIronMQReservationId", (Object)msg.getReservationId());
        message.setHeader("CamelIronMQReservedCount", (Object)msg.getReservedCount());
        return exchange;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.client = this.getConfiguration().getClient() != null ? this.getConfiguration().getClient() : this.getClient();
    }

    protected void doStop() throws Exception {
        this.client = null;
        super.doStop();
    }

    public Client getClient() {
        if (this.client == null) {
            this.client = this.createClient();
        }
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    Client createClient() {
        Cloud cloud;
        try {
            cloud = new Cloud(this.configuration.getIronMQCloud());
        }
        catch (MalformedURLException e) {
            cloud = Cloud.ironAWSUSEast;
            this.log.warn("Unable to parse ironMQCloud {} will use {}", (Object)this.configuration.getIronMQCloud(), (Object)cloud.getHost());
        }
        this.client = new Client(this.configuration.getProjectId(), this.configuration.getToken(), cloud);
        return this.client;
    }

    public IronMQConfiguration getConfiguration() {
        return this.configuration;
    }
}

