/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ironmq;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Message;

public final class GsonUtil {
    private static final Gson GSON = new Gson();

    private GsonUtil() {
    }

    static String getBodyFromMessage(Message message) {
        IronMqMessage ironMessage = new IronMqMessage((String)message.getBody(String.class), message.getHeaders());
        return GSON.toJson((Object)ironMessage);
    }

    static void copyFrom(io.iron.ironmq.Message source, Message target) {
        IronMqMessage ironMqMessage = (IronMqMessage)GSON.fromJson(source.getBody(), IronMqMessage.class);
        target.setBody((Object)ironMqMessage.getBody());
        if (ironMqMessage.getHeaders() != null) {
            for (Map.Entry<String, Object> entry : ironMqMessage.getHeaders().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (target.getHeader(key) != null) continue;
                target.setHeader(key, value);
            }
        }
    }

    static class IronMqMessage {
        private Map<String, Object> headers = new HashMap<String, Object>();
        private String body;

        IronMqMessage(String body, Map<String, Object> headers) {
            this.headers = headers;
            this.body = body;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }
    }
}

