/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.codehaus.jackson.map.ObjectMapper;

public class JacksonDataFormat
implements DataFormat {
    private final ObjectMapper objectMapper;
    private Class<?> unmarshalType;
    private Class<?> jsonView;

    public JacksonDataFormat() {
        this(new ObjectMapper(), HashMap.class);
    }

    public JacksonDataFormat(Class<?> unmarshalType) {
        this(new ObjectMapper(), unmarshalType);
    }

    public JacksonDataFormat(Class<?> unmarshalType, Class<?> jsonView) {
        this(new ObjectMapper(), unmarshalType, jsonView);
    }

    public JacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType) {
        this(mapper, unmarshalType, null);
    }

    public JacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType, Class<?> jsonView) {
        this.objectMapper = mapper;
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.objectMapper.writerWithView(this.jsonView).writeValue(stream, graph);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.objectMapper.readValue(stream, this.unmarshalType);
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

