/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;

public class JacksonDataFormat
extends ServiceSupport
implements DataFormat {
    private final ObjectMapper objectMapper;
    private Class<? extends Collection> collectionType;
    private Class<?> unmarshalType;
    private Class<?> jsonView;
    private String include;
    private boolean prettyPrint;
    private boolean allowJmsType;
    private boolean useList;

    public JacksonDataFormat() {
        this(HashMap.class);
    }

    public JacksonDataFormat(Class<?> unmarshalType) {
        this(unmarshalType, null);
    }

    public JacksonDataFormat(Class<?> unmarshalType, Class<?> jsonView) {
        this.objectMapper = new ObjectMapper();
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        this.objectMapper.registerModule((Module)module);
    }

    public JacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType) {
        this(mapper, unmarshalType, null);
    }

    public JacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType, Class<?> jsonView) {
        this.objectMapper = mapper;
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.objectMapper.writerWithView(this.jsonView).writeValue(stream, graph);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        Class clazz = this.unmarshalType;
        String type = (String)exchange.getIn().getHeader("CamelJacksonUnmarshalType", String.class);
        if (type == null && this.isAllowJmsType()) {
            type = (String)exchange.getIn().getHeader("JMSType", String.class);
        }
        if (type != null) {
            clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
        }
        if (this.collectionType != null) {
            CollectionType collType = this.objectMapper.getTypeFactory().constructCollectionType(this.collectionType, clazz);
            return this.objectMapper.readValue(stream, (JavaType)collType);
        }
        return this.objectMapper.readValue(stream, clazz);
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public Class<? extends Collection> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<? extends Collection> collectionType) {
        this.collectionType = collectionType;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public boolean isAllowJmsType() {
        return this.allowJmsType;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isUseList() {
        return this.useList;
    }

    public void setUseList(boolean useList) {
        this.useList = useList;
    }

    public void useList() {
        this.setCollectionType(ArrayList.class);
    }

    public void useMap() {
        this.setCollectionType(null);
        this.setUnmarshalType(HashMap.class);
    }

    public void setAllowJmsType(boolean allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    protected void doStart() throws Exception {
        if (this.useList) {
            this.setCollectionType(ArrayList.class);
        }
        if (this.include != null) {
            JsonInclude.Include inc = JsonInclude.Include.valueOf((String)this.include);
            this.objectMapper.setSerializationInclusion(inc);
        }
        if (this.prettyPrint) {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    protected void doStop() throws Exception {
    }
}

