package org.apache.camel.component.jackson.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class JacksonTypeConvertersLoader implements TypeConverterLoader {


    public JacksonTypeConvertersLoader() {
    }

    private void registerConverters() {
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addFallbackTypeConverter(new TypeConverterSupport() {
            @Override
            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return (T) getJacksonTypeConverters().convertTo(type, exchange, value, registry);
                } catch (TypeConversionException e) {
                    throw e;
                } catch (Exception e) {
                    throw new TypeConversionException(value, type, e);
                }
            }
        }, false);
    }

    private volatile org.apache.camel.component.jackson.converter.JacksonTypeConverters jacksonTypeConverters;
    private org.apache.camel.component.jackson.converter.JacksonTypeConverters getJacksonTypeConverters() {
        if (jacksonTypeConverters == null) {
            synchronized (this) {
                if (jacksonTypeConverters == null) {
                    jacksonTypeConverters = new org.apache.camel.component.jackson.converter.JacksonTypeConverters();
                }
            }
        }
        return jacksonTypeConverters;
    }
}
