/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.jackson.converter.JacksonTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;

public class JacksonTypeConvertersLoader
implements TypeConverterLoader {
    private volatile JacksonTypeConverters jacksonTypeConverters;

    private void registerConverters() {
    }

    public void load(final TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addFallbackTypeConverter((TypeConverter)new TypeConverterSupport(){

            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return JacksonTypeConvertersLoader.this.getJacksonTypeConverters().convertTo(type, exchange, value, registry);
                }
                catch (TypeConversionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TypeConversionException(value, type, (Throwable)e);
                }
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JacksonTypeConverters getJacksonTypeConverters() {
        if (this.jacksonTypeConverters == null) {
            JacksonTypeConvertersLoader jacksonTypeConvertersLoader = this;
            synchronized (jacksonTypeConvertersLoader) {
                if (this.jacksonTypeConverters == null) {
                    this.jacksonTypeConverters = new JacksonTypeConverters();
                }
            }
        }
        return this.jacksonTypeConverters;
    }
}

