package org.apache.camel.component.jacksonxml.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

/**
 * Source code generated by org.apache.camel:apt
 */
@SuppressWarnings("unchecked")
public final class JacksonXMLTypeConvertersLoader implements TypeConverterLoader {

    public JacksonXMLTypeConvertersLoader() {
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerFallbackConverters(registry);
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> getJacksonXMLTypeConverters().convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) { 
        registry.addFallbackTypeConverter(new SimpleTypeConverter(allowNull, method), canPromote);
    }

    private volatile org.apache.camel.component.jacksonxml.converter.JacksonXMLTypeConverters jacksonXMLTypeConverters;
    private org.apache.camel.component.jacksonxml.converter.JacksonXMLTypeConverters getJacksonXMLTypeConverters() {
        if (jacksonXMLTypeConverters == null) {
            synchronized (this) {
                if (jacksonXMLTypeConverters == null) {
                    jacksonXMLTypeConverters = new org.apache.camel.component.jacksonxml.converter.JacksonXMLTypeConverters();
                }
            }
        }
        return jacksonXMLTypeConverters;
    }
}
