/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.js;

import org.apache.camel.Exchange;
import org.apache.camel.language.js.JavaScriptHelper;
import org.apache.camel.support.ExpressionSupport;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class JavaScriptExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;

    public JavaScriptExpression(String expressionString, Class<?> type) {
        this.expressionString = expressionString;
        this.type = type;
    }

    public static JavaScriptExpression js(String expression) {
        return new JavaScriptExpression(expression, Object.class);
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        try (Context cx = JavaScriptHelper.newContext();){
            Object answer;
            Value b = cx.getBindings("js");
            b.putMember("exchange", (Object)exchange);
            b.putMember("context", (Object)exchange.getContext());
            b.putMember("exchangeId", (Object)exchange.getExchangeId());
            b.putMember("message", (Object)exchange.getMessage());
            b.putMember("headers", (Object)exchange.getMessage().getHeaders());
            b.putMember("properties", (Object)exchange.getAllProperties());
            b.putMember("body", exchange.getMessage().getBody());
            Source source = Source.newBuilder((String)"js", (CharSequence)this.expressionString, (String)"Unnamed").mimeType("application/javascript+module").buildLiteral();
            Value o = cx.eval(source);
            Object object = answer = o != null ? o.as(Object.class) : null;
            if (type == Object.class) {
                Object object2 = answer;
                return (T)object2;
            }
            Object object3 = exchange.getContext().getTypeConverter().convertTo(type, exchange, answer);
            return (T)object3;
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "JavaScript[" + this.expressionString + "]";
    }
}

