/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.IOHelper;

public class JaxbDataFormat
implements DataFormat {
    private JAXBContext context;
    private String contextPath;
    private boolean prettyPrint = true;
    private boolean ignoreJAXBElement = true;

    public JaxbDataFormat() {
    }

    public JaxbDataFormat(JAXBContext context) {
        this.context = context;
    }

    public JaxbDataFormat(String contextPath) {
        this.contextPath = contextPath;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws IOException {
        try {
            this.getContext().createMarshaller().marshal(graph, stream);
        }
        catch (JAXBException e) {
            throw IOHelper.createIOException((Throwable)e);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException, ClassNotFoundException {
        try {
            Object answer = this.getContext().createUnmarshaller().unmarshal(stream);
            if (answer instanceof JAXBElement && this.isIgnoreJAXBElement()) {
                answer = ((JAXBElement)answer).getValue();
            }
            return answer;
        }
        catch (JAXBException e) {
            throw IOHelper.createIOException((Throwable)e);
        }
    }

    public boolean isIgnoreJAXBElement() {
        return this.ignoreJAXBElement;
    }

    public void setIgnoreJAXBElement(boolean flag) {
        this.ignoreJAXBElement = flag;
    }

    public synchronized JAXBContext getContext() throws JAXBException {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(JAXBContext context) {
        this.context = context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    protected JAXBContext createContext() throws JAXBException {
        if (this.contextPath != null) {
            return JAXBContext.newInstance((String)this.contextPath);
        }
        return JAXBContext.newInstance((Class[])new Class[0]);
    }
}

