/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.TypeConverterAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackTypeConverter
implements TypeConverter,
TypeConverterAware {
    private static final transient Log LOG = LogFactory.getLog(FallbackTypeConverter.class);
    private Map<Class, JAXBContext> contexts = new HashMap<Class, JAXBContext>();
    private TypeConverter parentTypeConverter;
    private boolean prettyPrint = true;

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setTypeConverter(TypeConverter parentTypeConverter) {
        this.parentTypeConverter = parentTypeConverter;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        try {
            if (this.isJaxbType(type)) {
                return this.unmarshall(type, value);
            }
            if (value != null && this.isJaxbType(value.getClass()) && this.isNotStreamCacheType(type)) {
                return this.marshall(type, value);
            }
            return null;
        }
        catch (JAXBException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private <T> boolean isNotStreamCacheType(Class<T> type) {
        return !StreamCache.class.isAssignableFrom(type);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return this.convertTo(type, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        T answer = this.convertTo(type, value);
        if (answer == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return answer;
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, value);
    }

    protected <T> boolean isJaxbType(Class<T> type) {
        XmlRootElement element = type.getAnnotation(XmlRootElement.class);
        return element != null;
    }

    protected <T> T unmarshall(Class<T> type, Object value) throws JAXBException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot convert from null value to JAXBSource");
        }
        JAXBContext context = this.createContext(type);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.parentTypeConverter != null) {
            InputStream inputStream = (InputStream)this.parentTypeConverter.convertTo(InputStream.class, value);
            if (inputStream != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, inputStream);
                return type.cast(unmarshalled);
            }
            Reader reader = (Reader)this.parentTypeConverter.convertTo(Reader.class, value);
            if (reader != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, reader);
                return type.cast(unmarshalled);
            }
            Source source = (Source)this.parentTypeConverter.convertTo(Source.class, value);
            if (source != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, source);
                return type.cast(unmarshalled);
            }
        }
        if (value instanceof String) {
            value = new StringReader((String)value);
        }
        if (value instanceof InputStream || value instanceof Reader) {
            Object unmarshalled = this.unmarshal(unmarshaller, value);
            return type.cast(unmarshalled);
        }
        return null;
    }

    protected <T> T marshall(Class<T> type, Object value) throws JAXBException {
        JAXBContext context;
        JAXBSource source;
        Object answer = null;
        if (this.parentTypeConverter != null && (answer = this.parentTypeConverter.convertTo(type, (Object)(source = new JAXBSource(context = this.createContext(value.getClass()), value)))) == null) {
            StringWriter buffer = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)(this.isPrettyPrint() ? Boolean.TRUE : Boolean.FALSE));
            marshaller.marshal(value, (Writer)buffer);
            answer = this.parentTypeConverter.convertTo(type, (Object)buffer.toString());
        }
        return (T)answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshal(Unmarshaller unmarshaller, Object value) throws JAXBException {
        try {
            if (value instanceof InputStream) {
                Object object = unmarshaller.unmarshal((InputStream)value);
                return object;
            }
            if (value instanceof Reader) {
                Object object = unmarshaller.unmarshal((Reader)value);
                return object;
            }
            if (value instanceof Source) {
                Object object = unmarshaller.unmarshal((Source)value);
                return object;
            }
        }
        finally {
            if (value instanceof Closeable) {
                ObjectHelper.close((Closeable)((Closeable)value), (String)"Unmarshalling", (Log)LOG);
            }
        }
        return null;
    }

    protected synchronized <T> JAXBContext createContext(Class<T> type) throws JAXBException {
        JAXBContext context = this.contexts.get(type);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{type});
            this.contexts.put(type, context);
        }
        return context;
    }
}

