/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.jaxb.FilteringXmlStreamWriter;
import org.apache.camel.converter.jaxb.JaxbNamespacePrefixMapper;
import org.apache.camel.converter.jaxb.JaxbXmlStreamWriterWrapper;
import org.apache.camel.converter.jaxb.NamespacePrefixMapperFactory;
import org.apache.camel.converter.jaxb.NonXmlFilterReader;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class JaxbDataFormat
extends ServiceSupport
implements DataFormat,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbDataFormat.class);
    private static final BlockingQueue<SchemaFactory> SCHEMA_FACTORY_POOL = new LinkedBlockingQueue<SchemaFactory>();
    private SchemaFactory schemaFactory;
    private CamelContext camelContext;
    private JAXBContext context;
    private String contextPath;
    private String schema;
    private String schemaLocation;
    private boolean prettyPrint = true;
    private boolean ignoreJAXBElement = true;
    private boolean filterNonXmlChars;
    private String encoding;
    private boolean fragment;
    private QName partNamespace;
    private String partClass;
    private Class<Object> partialClass;
    private String namespacePrefixRef;
    private Map<String, String> namespacePrefix;
    private JaxbNamespacePrefixMapper namespacePrefixMapper;
    private JaxbXmlStreamWriterWrapper xmlStreamWriterWrapper;
    private TypeConverter typeConverter;
    private Schema cachedSchema;

    public JaxbDataFormat() {
    }

    public JaxbDataFormat(JAXBContext context) {
        this.context = context;
    }

    public JaxbDataFormat(String contextPath) {
        this.contextPath = contextPath;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws IOException, SAXException {
        try {
            String charset;
            Marshaller marshaller = this.createMarshaller();
            if (this.isPrettyPrint()) {
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            if ((charset = (String)exchange.getProperty("CamelCharsetName", String.class)) == null) {
                charset = this.encoding;
            }
            if (charset != null) {
                marshaller.setProperty("jaxb.encoding", (Object)charset);
            }
            if (this.isFragment()) {
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            }
            if (ObjectHelper.isNotEmpty((Object)this.schemaLocation)) {
                marshaller.setProperty("jaxb.schemaLocation", (Object)this.schemaLocation);
            }
            if (this.namespacePrefixMapper != null) {
                marshaller.setProperty(this.namespacePrefixMapper.getRegistrationKey(), (Object)this.namespacePrefixMapper);
            }
            this.marshal(exchange, graph, stream, marshaller);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    void marshal(Exchange exchange, Object graph, OutputStream stream, Marshaller marshaller) throws XMLStreamException, JAXBException {
        Object e = graph;
        if (this.partialClass != null && this.getPartNamespace() != null) {
            e = new JAXBElement(this.getPartNamespace(), this.partialClass, graph);
        }
        if (this.asXmlStreamWriter(exchange)) {
            XMLStreamWriter writer = (XMLStreamWriter)this.typeConverter.convertTo(XMLStreamWriter.class, (Object)stream);
            if (this.needFiltering(exchange)) {
                writer = new FilteringXmlStreamWriter(writer);
            }
            if (this.xmlStreamWriterWrapper != null) {
                writer = this.xmlStreamWriterWrapper.wrapWriter(writer);
            }
            marshaller.marshal(e, writer);
        } else {
            marshaller.marshal(e, stream);
        }
    }

    private boolean asXmlStreamWriter(Exchange exchange) {
        return this.needFiltering(exchange) || this.xmlStreamWriterWrapper != null;
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException, SAXException {
        try {
            XMLStreamReader xmlReader = this.needFiltering(exchange) ? (XMLStreamReader)this.typeConverter.convertTo(XMLStreamReader.class, (Object)this.createNonXmlFilterReader(exchange, stream)) : (XMLStreamReader)this.typeConverter.convertTo(XMLStreamReader.class, (Object)stream);
            Object answer = this.partialClass != null ? this.createUnmarshaller().unmarshal(xmlReader, this.partialClass) : this.createUnmarshaller().unmarshal(xmlReader);
            if (answer instanceof JAXBElement && this.isIgnoreJAXBElement()) {
                answer = ((JAXBElement)answer).getValue();
            }
            return answer;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private NonXmlFilterReader createNonXmlFilterReader(Exchange exchange, InputStream stream) throws UnsupportedEncodingException {
        return new NonXmlFilterReader(new InputStreamReader(stream, IOHelper.getCharsetName((Exchange)exchange)));
    }

    protected boolean needFiltering(Exchange exchange) {
        return exchange == null ? this.filterNonXmlChars : (Boolean)exchange.getProperty("CamelFilterNonXmlChars", (Object)this.filterNonXmlChars, Boolean.class);
    }

    public boolean isIgnoreJAXBElement() {
        return this.ignoreJAXBElement;
    }

    public void setIgnoreJAXBElement(boolean flag) {
        this.ignoreJAXBElement = flag;
    }

    public JAXBContext getContext() {
        return this.context;
    }

    public void setContext(JAXBContext context) {
        this.context = context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public SchemaFactory getSchemaFactory() {
        if (this.schemaFactory == null) {
            return this.getOrCreateSchemaFactory();
        }
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public boolean isFilterNonXmlChars() {
        return this.filterNonXmlChars;
    }

    public void setFilterNonXmlChars(boolean filterNonXmlChars) {
        this.filterNonXmlChars = filterNonXmlChars;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public QName getPartNamespace() {
        return this.partNamespace;
    }

    public void setPartNamespace(QName partNamespace) {
        this.partNamespace = partNamespace;
    }

    public String getPartClass() {
        return this.partClass;
    }

    public void setPartClass(String partClass) {
        this.partClass = partClass;
    }

    public Map<String, String> getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(Map<String, String> namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public String getNamespacePrefixRef() {
        return this.namespacePrefixRef;
    }

    public void setNamespacePrefixRef(String namespacePrefixRef) {
        this.namespacePrefixRef = namespacePrefixRef;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public JaxbXmlStreamWriterWrapper getXmlStreamWriterWrapper() {
        return this.xmlStreamWriterWrapper;
    }

    public void setXmlStreamWriterWrapper(JaxbXmlStreamWriterWrapper xmlStreamWriterWrapper) {
        this.xmlStreamWriterWrapper = xmlStreamWriterWrapper;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        if (this.context == null) {
            this.context = this.createContext();
        }
        if (this.partClass != null) {
            this.partialClass = this.camelContext.getClassResolver().resolveMandatoryClass(this.partClass, Object.class);
        }
        if (this.namespacePrefixRef != null) {
            this.namespacePrefix = (Map)CamelContextHelper.mandatoryLookup((CamelContext)this.camelContext, (String)this.namespacePrefixRef, Map.class);
        }
        if (this.namespacePrefix != null) {
            this.namespacePrefixMapper = NamespacePrefixMapperFactory.newNamespacePrefixMapper(this.camelContext, this.namespacePrefix);
        }
        this.typeConverter = this.camelContext.getTypeConverter();
        if (this.schema != null) {
            this.cachedSchema = this.createSchema(this.getSources());
        }
    }

    protected void doStop() throws Exception {
    }

    protected JAXBContext createContext() throws JAXBException {
        if (this.contextPath != null) {
            ClassLoader cl = this.camelContext.getApplicationContextClassLoader();
            if (cl != null) {
                LOG.info("Creating JAXBContext with contextPath: " + this.contextPath + " and ApplicationContextClassLoader: " + cl);
                return JAXBContext.newInstance((String)this.contextPath, (ClassLoader)cl);
            }
            LOG.info("Creating JAXBContext with contextPath: " + this.contextPath);
            return JAXBContext.newInstance((String)this.contextPath);
        }
        LOG.info("Creating JAXBContext");
        return JAXBContext.newInstance((Class[])new Class[0]);
    }

    protected Unmarshaller createUnmarshaller() throws JAXBException, SAXException, FileNotFoundException, MalformedURLException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.cachedSchema);
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return event.getSeverity() == 0;
                }
            });
        }
        return unmarshaller;
    }

    protected Marshaller createMarshaller() throws JAXBException, SAXException, FileNotFoundException, MalformedURLException {
        Marshaller marshaller = this.getContext().createMarshaller();
        if (this.schema != null) {
            marshaller.setSchema(this.cachedSchema);
            marshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return event.getSeverity() == 0;
                }
            });
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema createSchema(Source[] sources) throws SAXException {
        SchemaFactory factory = this.getOrCreateSchemaFactory();
        try {
            Schema schema = factory.newSchema(sources);
            return schema;
        }
        finally {
            this.returnSchemaFactory(factory);
        }
    }

    private Source[] getSources() throws FileNotFoundException, MalformedURLException {
        String[] schemas = this.schema.split(",");
        Source[] sources = new Source[schemas.length];
        for (int i = 0; i < schemas.length; ++i) {
            URL schemaUrl = ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)this.camelContext.getClassResolver(), (String)schemas[i]);
            sources[i] = new StreamSource(schemaUrl.toExternalForm());
        }
        return sources;
    }

    private SchemaFactory getOrCreateSchemaFactory() {
        SchemaFactory factory = (SchemaFactory)SCHEMA_FACTORY_POOL.poll();
        if (factory == null) {
            factory = JaxbDataFormat.createSchemaFactory();
        }
        return factory;
    }

    public static SchemaFactory createSchemaFactory() {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    private void returnSchemaFactory(SchemaFactory factory) {
        if (factory != this.schemaFactory) {
            SCHEMA_FACTORY_POOL.offer(factory);
        }
    }
}

