package org.apache.camel.converter.jaxb;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class FallbackTypeConverterLoader implements TypeConverterLoader {


    public FallbackTypeConverterLoader() {
    }

    private void registerConverters() {
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addFallbackTypeConverter(new TypeConverterSupport() {
            @Override
            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return (T) getFallbackTypeConverter().convertTo(type, exchange, value, registry);
                } catch (TypeConversionException e) {
                    throw e;
                } catch (Exception e) {
                    throw new TypeConversionException(value, type, e);
                }
            }
        }, false);
    }

    private volatile org.apache.camel.converter.jaxb.FallbackTypeConverter fallbackTypeConverter;
    private org.apache.camel.converter.jaxb.FallbackTypeConverter getFallbackTypeConverter() {
        if (fallbackTypeConverter == null) {
            synchronized (this) {
                if (fallbackTypeConverter == null) {
                    fallbackTypeConverter = new org.apache.camel.converter.jaxb.FallbackTypeConverter();
                }
            }
        }
        return fallbackTypeConverter;
    }
}
