/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.FallbackConverter;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.jaxb.FilteringXmlStreamWriter;
import org.apache.camel.converter.jaxb.JaxbHelper;
import org.apache.camel.converter.jaxb.NonXmlFilterReader;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public class FallbackTypeConverter {
    public static final String PRETTY_PRINT = "CamelJaxbPrettyPrint";
    public static final String OBJECT_FACTORY = "CamelJaxbObjectFactory";
    private static final Logger LOG = LoggerFactory.getLogger(FallbackTypeConverter.class);
    private final Map<AnnotatedElement, JAXBContext> contexts = new HashMap<AnnotatedElement, JAXBContext>();
    private final StaxConverter staxConverter = new StaxConverter();
    private boolean defaultPrettyPrint = true;
    private boolean defaultObjectFactory;

    public boolean isPrettyPrint() {
        return this.defaultPrettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.defaultPrettyPrint = prettyPrint;
    }

    public boolean isObjectFactory() {
        return this.defaultObjectFactory;
    }

    public void setObjectFactory(boolean objectFactory) {
        this.defaultObjectFactory = objectFactory;
    }

    @FallbackConverter
    @Converter(fallback=true)
    public Object convertTo(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        String property;
        boolean prettyPrint = this.defaultPrettyPrint;
        String string = property = exchange != null ? exchange.getContext().getGlobalOption(PRETTY_PRINT) : null;
        if (property != null) {
            prettyPrint = !property.equalsIgnoreCase("false");
        }
        boolean objectFactory = this.defaultObjectFactory;
        String string2 = property = exchange != null ? exchange.getContext().getGlobalOption(OBJECT_FACTORY) : null;
        if (property != null) {
            objectFactory = !property.equalsIgnoreCase("false");
        }
        TypeConverter converter = null;
        if (registry instanceof TypeConverter) {
            converter = (TypeConverter)registry;
        } else if (exchange != null) {
            converter = exchange.getContext().getTypeConverter();
        }
        try {
            if (this.isJaxbType(type, exchange, objectFactory)) {
                return this.unmarshall(type, exchange, value, converter);
            }
            if (value != null && FallbackTypeConverter.isNotStreamCacheType(type)) {
                Method objectFactoryMethod;
                if (this.hasXmlRootElement(value.getClass())) {
                    return this.marshall(type, exchange, value, converter, null, prettyPrint);
                }
                if (objectFactory && (objectFactoryMethod = JaxbHelper.getJaxbElementFactoryMethod(exchange.getContext(), value.getClass())) != null) {
                    return this.marshall(type, exchange, value, converter, objectFactoryMethod, prettyPrint);
                }
            }
        }
        catch (Exception e) {
            throw new TypeConversionException(value, type, (Throwable)e);
        }
        return null;
    }

    private <T> boolean hasXmlRootElement(Class<T> type) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    protected <T> boolean isJaxbType(Class<T> type, Exchange exchange, boolean objectFactory) {
        if (objectFactory) {
            return this.hasXmlRootElement(type) || JaxbHelper.getJaxbElementFactoryMethod(exchange.getContext(), type) != null;
        }
        return this.hasXmlRootElement(type);
    }

    private <T> T castJaxbType(Object o, Class<T> type) {
        if (type.isAssignableFrom(o.getClass())) {
            return type.cast(o);
        }
        return type.cast(((JAXBElement)o).getValue());
    }

    protected <T> T unmarshall(Class<T> type, Exchange exchange, Object value, TypeConverter converter) throws Exception {
        LOG.trace("Unmarshal to {} with value {}", type, value);
        if (value == null) {
            throw new IllegalArgumentException("Cannot convert from null value to JAXBSource");
        }
        Unmarshaller unmarshaller = this.getUnmarshaller(type);
        if (converter != null) {
            InputStream inputStream;
            XMLStreamReader xmlReader;
            if (!this.needFiltering(exchange) && (xmlReader = (XMLStreamReader)converter.convertTo(XMLStreamReader.class, exchange, value)) != null) {
                try {
                    Object unmarshalled = this.unmarshal(unmarshaller, exchange, xmlReader);
                    return this.castJaxbType(unmarshalled, type);
                }
                catch (Exception ex) {
                    LOG.debug("Cannot use StaxStreamReader to unmarshal the message, due to {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
            if ((inputStream = (InputStream)converter.convertTo(InputStream.class, exchange, value)) != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, exchange, inputStream);
                return this.castJaxbType(unmarshalled, type);
            }
            Reader reader = (Reader)converter.convertTo(Reader.class, exchange, value);
            if (reader != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, exchange, reader);
                return this.castJaxbType(unmarshalled, type);
            }
            Source source = (Source)converter.convertTo(Source.class, exchange, value);
            if (source != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, exchange, source);
                return this.castJaxbType(unmarshalled, type);
            }
        }
        if (value instanceof String) {
            value = new StringReader((String)value);
        }
        if (value instanceof InputStream || value instanceof Reader) {
            Object unmarshalled = this.unmarshal(unmarshaller, exchange, value);
            return this.castJaxbType(unmarshalled, type);
        }
        return null;
    }

    protected <T> T marshall(Class<T> type, Exchange exchange, Object value, TypeConverter converter, Method objectFactoryMethod, boolean prettyPrint) throws JAXBException, FactoryConfigurationError, TypeConversionException {
        LOG.trace("Marshal from value {} to type {}", value, type);
        Object answer = null;
        if (converter != null) {
            String charset;
            JAXBContext context = this.createContext(value.getClass());
            Marshaller marshaller = context.createMarshaller();
            StringWriter buffer = new StringWriter();
            if (prettyPrint) {
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            String string = charset = exchange != null ? (String)exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class) : null;
            if (charset != null) {
                marshaller.setProperty("jaxb.encoding", (Object)charset);
            }
            Object toMarshall = value;
            if (objectFactoryMethod != null) {
                try {
                    Object instance = objectFactoryMethod.getDeclaringClass().newInstance();
                    if (instance != null) {
                        toMarshall = objectFactoryMethod.invoke(instance, value);
                    }
                }
                catch (Exception e) {
                    LOG.debug("Unable to create JAXBElement object for type {} due to {}", new Object[]{value.getClass(), e.getMessage(), e});
                }
            }
            if (this.needFiltering(exchange)) {
                XMLStreamWriter writer = (XMLStreamWriter)converter.convertTo(XMLStreamWriter.class, (Object)buffer);
                FilteringXmlStreamWriter filteringWriter = new FilteringXmlStreamWriter(writer, charset);
                marshaller.marshal(toMarshall, (XMLStreamWriter)filteringWriter);
            } else {
                marshaller.marshal(toMarshall, (Writer)buffer);
            }
            answer = converter.convertTo(type, exchange, (Object)((Object)buffer).toString());
        }
        return (T)answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshal(Unmarshaller unmarshaller, Exchange exchange, Object value) throws JAXBException, UnsupportedEncodingException, XMLStreamException {
        try {
            XMLStreamReader xmlReader;
            if (value instanceof XMLStreamReader) {
                xmlReader = (XMLStreamReader)value;
            } else if (value instanceof InputStream) {
                xmlReader = this.needFiltering(exchange) ? this.staxConverter.createXMLStreamReader((Reader)new NonXmlFilterReader(new InputStreamReader((InputStream)value, ExchangeHelper.getCharsetName((Exchange)exchange)))) : this.staxConverter.createXMLStreamReader((InputStream)value, exchange);
            } else if (value instanceof Reader) {
                Reader reader = (Reader)value;
                if (this.needFiltering(exchange) && !(value instanceof NonXmlFilterReader)) {
                    reader = new NonXmlFilterReader((Reader)value);
                }
                xmlReader = this.staxConverter.createXMLStreamReader(reader);
            } else if (value instanceof Source) {
                xmlReader = this.staxConverter.createXMLStreamReader((Source)value);
            } else {
                throw new IllegalArgumentException("Cannot convert from " + value.getClass());
            }
            Object object = unmarshaller.unmarshal(xmlReader);
            return object;
        }
        finally {
            if (value instanceof Closeable) {
                IOHelper.close((Closeable)((Closeable)value), (String)"Unmarshalling", (Logger)LOG);
            }
        }
    }

    protected boolean needFiltering(Exchange exchange) {
        return exchange != null && (Boolean)exchange.getProperty("CamelFilterNonXmlChars", (Object)Boolean.FALSE, Boolean.class) != false;
    }

    protected synchronized <T> JAXBContext createContext(Class<T> type) throws JAXBException {
        AnnotatedElement ae = this.hasXmlRootElement(type) ? type : type.getPackage();
        JAXBContext context = this.contexts.get(ae);
        if (context == null) {
            if (this.hasXmlRootElement(type)) {
                context = JAXBContext.newInstance((Class[])new Class[]{type});
                this.contexts.put(type, context);
            } else {
                context = JAXBContext.newInstance((String)type.getPackage().getName());
                this.contexts.put(type.getPackage(), context);
            }
        }
        return context;
    }

    protected <T> Unmarshaller getUnmarshaller(Class<T> type) throws JAXBException {
        JAXBContext context = this.createContext(type);
        return context.createUnmarshaller();
    }

    private static <T> boolean isNotStreamCacheType(Class<T> type) {
        return !StreamCache.class.isAssignableFrom(type);
    }
}

