package org.apache.camel.converter.jaxp;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

/**
 * Source code generated by org.apache.camel:apt
 */
@SuppressWarnings("unchecked")
public final class DomConverterLoader implements TypeConverterLoader {

    public DomConverterLoader() {
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        addTypeConverter(registry, byte[].class, org.w3c.dom.NodeList.class, false,
            (type, exchange, value) -> getDomConverter().toByteArray((org.w3c.dom.NodeList) value, exchange));
        addTypeConverter(registry, java.io.InputStream.class, org.w3c.dom.NodeList.class, false,
            (type, exchange, value) -> getDomConverter().toInputStream((org.w3c.dom.NodeList) value, exchange));
        addTypeConverter(registry, java.lang.Integer.class, org.w3c.dom.NodeList.class, false,
            (type, exchange, value) -> org.apache.camel.converter.jaxp.DomConverter.toInteger((org.w3c.dom.NodeList) value));
        addTypeConverter(registry, java.lang.Long.class, org.w3c.dom.NodeList.class, false,
            (type, exchange, value) -> org.apache.camel.converter.jaxp.DomConverter.toLong((org.w3c.dom.NodeList) value));
        addTypeConverter(registry, java.lang.String.class, org.w3c.dom.NodeList.class, false,
            (type, exchange, value) -> getDomConverter().toString((org.w3c.dom.NodeList) value, exchange));
        addTypeConverter(registry, java.util.List.class, org.w3c.dom.NodeList.class, false,
            (type, exchange, value) -> org.apache.camel.converter.jaxp.DomConverter.toList((org.w3c.dom.NodeList) value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) { 
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

    private volatile org.apache.camel.converter.jaxp.DomConverter domConverter;
    private org.apache.camel.converter.jaxp.DomConverter getDomConverter() {
        if (domConverter == null) {
            synchronized (this) {
                if (domConverter == null) {
                    domConverter = new org.apache.camel.converter.jaxp.DomConverter();
                }
            }
        }
        return domConverter;
    }
}
