/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jbang.console;

import java.io.BufferedReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.RouteOnDemandReloadStrategy;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="source-dir", group="camel-jbang", displayName="Source Directory", description="Information about Camel JBang source files")
public class SourceDirDevConsole
extends AbstractDevConsole {
    public static final String SOURCE = "source";

    public SourceDirDevConsole() {
        super("camel-jbang", "source-dir", "Source Directory", "Information about Camel JBang source files");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb;
        block19: {
            String path = (String)options.get("CamelHttpPath");
            String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
            String source = (String)options.get(SOURCE);
            sb = new StringBuilder();
            RouteOnDemandReloadStrategy reload = (RouteOnDemandReloadStrategy)this.getCamelContext().hasService(RouteOnDemandReloadStrategy.class);
            if (reload != null) {
                sb.append(String.format("Directory: %s%n", reload.getFolder()));
                Path dir = Paths.get(reload.getFolder(), new String[0]);
                if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
                    try {
                        List files = Files.list(dir).collect(Collectors.toList());
                        if (files.isEmpty()) break block19;
                        sb.append("Files:\n");
                        files.sort((o1, o2) -> o1.getFileName().toString().compareToIgnoreCase(o2.getFileName().toString()));
                        for (Path f : files) {
                            boolean match;
                            String fileName = f.getFileName().toString();
                            boolean skip = fileName.startsWith(".") || Files.isHidden(f);
                            if (skip || !(match = subPath == null || fileName.startsWith(subPath) || fileName.endsWith(subPath) || PatternHelper.matchPattern((String)fileName, (String)subPath))) continue;
                            long size = Files.size(f);
                            long ts = Files.getLastModifiedTime(f, new LinkOption[0]).toMillis();
                            String age = ts > 0L ? TimeUtils.printSince((long)ts) : "n/a";
                            sb.append(String.format("    %s (size: %d age: %s)%n", fileName, size, age));
                            if (!"true".equals(source)) continue;
                            StringBuilder code = new StringBuilder();
                            try (BufferedReader fileReader = Files.newBufferedReader(f, StandardCharsets.UTF_8);
                                 LineNumberReader reader = new LineNumberReader(fileReader);){
                                String t;
                                int i = 0;
                                do {
                                    if ((t = reader.readLine()) == null) continue;
                                    code.append(String.format("\n    #%s %s", ++i, t));
                                } while (t != null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (code.isEmpty()) continue;
                            sb.append("    ").append("-".repeat(40));
                            sb.append((CharSequence)code);
                            sb.append("\n\n");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root;
        block15: {
            String path = (String)options.get("CamelHttpPath");
            String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
            String source = (String)options.get(SOURCE);
            root = new JsonObject();
            RouteOnDemandReloadStrategy reload = (RouteOnDemandReloadStrategy)this.getCamelContext().hasService(RouteOnDemandReloadStrategy.class);
            if (reload != null) {
                root.put((Object)"dir", (Object)reload.getFolder());
                Path dir = Paths.get(reload.getFolder(), new String[0]);
                if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
                    try {
                        List files = Files.list(dir).collect(Collectors.toList());
                        if (files.isEmpty()) break block15;
                        files.sort((o1, o2) -> o1.getFileName().toString().compareToIgnoreCase(o2.getFileName().toString()));
                        JsonArray arr = new JsonArray();
                        root.put((Object)"files", (Object)arr);
                        for (Path f : files) {
                            boolean match;
                            String fileName = f.getFileName().toString();
                            boolean skip = fileName.startsWith(".") || Files.isHidden(f);
                            if (skip || !(match = subPath == null || fileName.startsWith(subPath) || fileName.endsWith(subPath) || PatternHelper.matchPattern((String)fileName, (String)subPath))) continue;
                            JsonObject jo = new JsonObject();
                            jo.put((Object)"name", (Object)fileName);
                            jo.put((Object)"size", (Object)Files.size(f));
                            jo.put((Object)"lastModified", (Object)Files.getLastModifiedTime(f, new LinkOption[0]).toMillis());
                            if ("true".equals(source)) {
                                try (BufferedReader fileReader = Files.newBufferedReader(f, StandardCharsets.UTF_8);){
                                    List code = ConsoleHelper.loadSourceAsJson((Reader)fileReader, null);
                                    if (code != null) {
                                        jo.put((Object)"code", (Object)code);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            arr.add((Object)jo);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return root;
    }
}

