/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Addons;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.CamelBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.ContainerBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.EnvironmentBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.IngressBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.KnativeBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.KnativeServiceBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.MountBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.OpenapiBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.RouteBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.ServiceBindingBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.ServiceBuilder;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;

public final class TraitsBuilder {
    private Map<String, Addons> addons;
    private CamelBuilder camel;
    private ContainerBuilder container;
    private EnvironmentBuilder environment;
    private IngressBuilder ingress;
    private KnativeBuilder knative;
    private KnativeServiceBuilder knativeService;
    private MountBuilder mount;
    private OpenapiBuilder openapi;
    private RouteBuilder route;
    private ServiceBuilder service;
    private ServiceBindingBuilder serviceBinding;

    private TraitsBuilder() {
    }

    public static TraitsBuilder traits() {
        return new TraitsBuilder();
    }

    public TraitsBuilder addToAddons(String key, Addons value) {
        if (this.addons == null && key != null && value != null) {
            this.addons = new LinkedHashMap<String, Addons>();
        }
        if (key != null && value != null) {
            this.addons.put(key, value);
        }
        return this;
    }

    public TraitsBuilder addToAddons(Map<String, Addons> map) {
        if (this.addons == null && map != null) {
            this.addons = new LinkedHashMap<String, Addons>();
        }
        if (map != null) {
            this.addons.putAll(map);
        }
        return this;
    }

    public TraitsBuilder removeFromAddons(String key) {
        if (this.addons != null && key != null) {
            this.addons.remove(key);
        }
        return this;
    }

    public TraitsBuilder removeFromAddons(Map<String, Addons> map) {
        if (this.addons != null && map != null) {
            for (String key : map.keySet()) {
                if (this.addons == null) continue;
                this.addons.remove(key);
            }
        }
        return this;
    }

    public Map<String, Addons> getAddons() {
        return this.addons;
    }

    public <K, V> TraitsBuilder withAddons(Map<String, Addons> addons) {
        this.addons = addons == null ? null : new LinkedHashMap<String, Addons>(addons);
        return this;
    }

    public boolean hasAddons() {
        return this.addons != null;
    }

    public TraitsBuilder withCamel(CamelBuilder camel) {
        this.camel = camel;
        return this;
    }

    public TraitsBuilder withContainer(ContainerBuilder container) {
        this.container = container;
        return this;
    }

    public TraitsBuilder withEnvironment(EnvironmentBuilder environment) {
        this.environment = environment;
        return this;
    }

    public TraitsBuilder withIngress(IngressBuilder ingress) {
        this.ingress = ingress;
        return this;
    }

    public TraitsBuilder withKnative(KnativeBuilder knative) {
        this.knative = knative;
        return this;
    }

    public TraitsBuilder withKnativeService(KnativeServiceBuilder knativeService) {
        this.knativeService = knativeService;
        return this;
    }

    public TraitsBuilder withMount(MountBuilder mount) {
        this.mount = mount;
        return this;
    }

    public TraitsBuilder withOpenapi(OpenapiBuilder openapi) {
        this.openapi = openapi;
        return this;
    }

    public TraitsBuilder withRoute(RouteBuilder route) {
        this.route = route;
        return this;
    }

    public TraitsBuilder withService(ServiceBuilder service) {
        this.service = service;
        return this;
    }

    public TraitsBuilder withServiceBinding(ServiceBindingBuilder serviceBinding) {
        this.serviceBinding = serviceBinding;
        return this;
    }

    public Traits build() {
        Traits traits = new Traits();
        traits.setAddons(this.addons);
        if (this.camel != null) {
            traits.setCamel(this.camel.build());
        }
        if (this.container != null) {
            traits.setContainer(this.container.build());
        }
        if (this.environment != null) {
            traits.setEnvironment(this.environment.build());
        }
        if (this.ingress != null) {
            traits.setIngress(this.ingress.build());
        }
        if (this.knative != null) {
            traits.setKnative(this.knative.build());
        }
        if (this.knativeService != null) {
            traits.setKnativeService(this.knativeService.build());
        }
        if (this.mount != null) {
            traits.setMount(this.mount.build());
        }
        if (this.openapi != null) {
            traits.setOpenapi(this.openapi.build());
        }
        if (this.route != null) {
            traits.setRoute(this.route.build());
        }
        if (this.service != null) {
            traits.setService(this.service.build());
        }
        if (this.serviceBinding != null) {
            traits.setServiceBinding(this.serviceBinding.build());
        }
        return traits;
    }
}

