/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fabric8.kubernetes.api.model.APIGroup;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.common.YamlHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.yaml.snakeyaml.Yaml;

public final class KubernetesHelper {
    private static KubernetesClient kubernetesClient;
    private static final Map<String, KubernetesClient> clients;
    private static final ObjectMapper OBJECT_MAPPER;

    private KubernetesHelper() {
    }

    public static KubernetesClient getKubernetesClient() {
        if (kubernetesClient == null) {
            kubernetesClient = new KubernetesClientBuilder().build();
        }
        KubernetesHelper.setKubernetesClientProperties();
        return kubernetesClient;
    }

    public static KubernetesClient getKubernetesClient(String config) {
        if (clients.containsKey(config)) {
            return clients.get(config);
        }
        KubernetesHelper.setKubernetesClientProperties();
        KubernetesClient client = new KubernetesClientBuilder().withConfig(config).build();
        return clients.put(config, client);
    }

    private static void setKubernetesClientProperties() {
        if (System.getProperty("kubernetes.connection.timeout") == null) {
            System.setProperty("kubernetes.connection.timeout", "2000");
        }
        if (System.getProperty("kubernetes.request.timeout") == null) {
            System.setProperty("kubernetes.request.timeout", "2000");
        }
        if (System.getProperty("kubernetes.request.retry.backoffLimit") == null) {
            System.setProperty("kubernetes.request.retry.backoffLimit", "1");
        }
    }

    public static Yaml yaml() {
        return YamlHelper.yaml();
    }

    public static Yaml yaml(ClassLoader classLoader) {
        return YamlHelper.yaml((ClassLoader)classLoader);
    }

    public static ObjectMapper json() {
        return OBJECT_MAPPER;
    }

    static ClusterType discoverClusterType() {
        ClusterType cluster = ClusterType.KUBERNETES;
        if (KubernetesHelper.isConnectedToOpenshift()) {
            cluster = ClusterType.OPENSHIFT;
        } else if (KubernetesHelper.isConnectedToMinikube()) {
            cluster = ClusterType.MINIKUBE;
        }
        return cluster;
    }

    private static boolean isConnectedToOpenshift() {
        boolean ocp = false;
        try {
            APIGroup apiGroup = KubernetesHelper.getKubernetesClient().getApiGroup("config.openshift.io");
            ocp = apiGroup != null;
        }
        catch (RuntimeException e) {
            System.out.println("Failed to detect cluster: " + e.getMessage() + ", default to kubernetes.");
        }
        return ocp;
    }

    private static boolean isConnectedToMinikube() {
        boolean minikube = false;
        boolean minikubeEnv = false;
        try {
            ResourceDefinitionContext nodecrd = new ResourceDefinitionContext.Builder().withVersion("v1").withKind("Node").withNamespaced(false).build();
            GenericKubernetesResourceList list = (GenericKubernetesResourceList)((FilterWatchListDeletable)KubernetesHelper.getKubernetesClient().genericKubernetesResources(nodecrd).withLabels(Collections.singletonMap("minikube.k8s.io/name", null))).list();
            minikube = list.getItems().size() > 0;
            boolean bl = minikubeEnv = System.getenv("MINIKUBE_ACTIVE_DOCKERD") != null && System.getenv("DOCKER_TLS_VERIFY") != null;
            if (minikube && !minikubeEnv) {
                System.out.println("It seems you have minikube running but forgot to run \"eval $(minikube docker-env)\", default cluster to kubernetes.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minikube && minikubeEnv;
    }

    public static void skipKnativeImageTagResolutionInMinikube() {
        ConfigMap cm = (ConfigMap)((Resource)((NonNamespaceOperation)KubernetesHelper.getKubernetesClient().configMaps().inNamespace("knative-serving")).withName("config-deployment")).get();
        Map data = cm.getData();
        String skipTag = (String)data.get("registries-skipping-tag-resolving");
        if (skipTag == null || !skipTag.contains("localhost:5000")) {
            ((Resource)((NonNamespaceOperation)KubernetesHelper.getKubernetesClient().configMaps().inNamespace("knative-serving")).withName("config-deployment")).edit(c -> ((ConfigMapBuilder)new ConfigMapBuilder(c).addToData("registries-skipping-tag-resolving", "localhost:5000")).build());
        }
    }

    public static String sanitize(String name) {
        if (name != null) {
            name = FileUtil.onlyName((String)name);
            name = StringHelper.sanitize((String)name);
            name = StringHelper.camelCaseToDash((String)name);
            name = name.toLowerCase(Locale.US);
            name = name.replaceAll("[^a-z0-9-]", "");
            name = name.trim();
        }
        return name;
    }

    public static void setKubernetesClient(KubernetesClient kubernetesClient) {
        KubernetesHelper.kubernetesClient = kubernetesClient;
    }

    public static String dumpYaml(Object model) {
        return KubernetesHelper.yaml().dumpAsMap(KubernetesHelper.json().convertValue(model, Map.class));
    }

    public static Map<String, Object> toJsonMap(Object model) {
        return (Map)KubernetesHelper.json().convertValue(model, Map.class);
    }

    public static File resolveKubernetesManifest(String clusterType, String workingDir) throws FileNotFoundException {
        return KubernetesHelper.resolveKubernetesManifest(clusterType, new File(workingDir));
    }

    public static File resolveKubernetesManifest(String clusterType, String workingDir, String extension) throws FileNotFoundException {
        return KubernetesHelper.resolveKubernetesManifest(clusterType, new File(workingDir), extension);
    }

    public static File resolveKubernetesManifest(String clusterType, File workingDir) throws FileNotFoundException {
        return KubernetesHelper.resolveKubernetesManifest(clusterType, workingDir, "yml");
    }

    public static File resolveKubernetesManifest(String clusterType, File workingDir, String extension) throws FileNotFoundException {
        File manifest = KubernetesHelper.getKubernetesManifest(clusterType, workingDir);
        if (manifest.exists()) {
            return manifest;
        }
        throw new FileNotFoundException("Unable to resolve Kubernetes manifest file type `%s` in folder: %s".formatted(extension, workingDir.toPath().toString()));
    }

    public static Path resolveKubernetesManifestPath(String clusterType, Path workingDir) throws FileNotFoundException {
        return KubernetesHelper.resolveKubernetesManifestPath(clusterType, workingDir, "yml");
    }

    public static Path resolveKubernetesManifestPath(String clusterType, Path workingDir, String extension) throws FileNotFoundException {
        Path manifestPath = KubernetesHelper.getKubernetesManifestPath(clusterType, workingDir, extension);
        if (Files.exists(manifestPath, new LinkOption[0])) {
            return manifestPath;
        }
        throw new FileNotFoundException("Unable to resolve Kubernetes manifest file type `%s` in folder: %s".formatted(extension, workingDir.toString()));
    }

    public static String getPodPhase(Pod pod) {
        return Optional.ofNullable(pod).map(p -> p.getStatus().getPhase()).orElse("Unknown");
    }

    public static File getKubernetesManifest(String clusterType, String workingDir) {
        return KubernetesHelper.getKubernetesManifest(clusterType, new File(workingDir));
    }

    public static File getKubernetesManifest(String clusterType, File workingDir) {
        return KubernetesHelper.getKubernetesManifest(clusterType, workingDir, "yml");
    }

    public static File getKubernetesManifest(String clusterType, File workingDir, String extension) {
        String manifestFile = ClusterType.KIND.isEqualTo(clusterType) || ClusterType.MINIKUBE.isEqualTo(clusterType) ? "kubernetes" : Optional.ofNullable(clusterType).map(String::toLowerCase).orElse("kubernetes");
        return new File(workingDir, "%s.%s".formatted(manifestFile, extension));
    }

    public static Path getKubernetesManifestPath(String clusterType, Path workingDir) {
        return KubernetesHelper.getKubernetesManifestPath(clusterType, workingDir, "yml");
    }

    public static Path getKubernetesManifestPath(String clusterType, Path workingDir, String extension) {
        String manifestFile = ClusterType.KIND.isEqualTo(clusterType) || ClusterType.MINIKUBE.isEqualTo(clusterType) ? "kubernetes" : Optional.ofNullable(clusterType).map(String::toLowerCase).orElse("kubernetes");
        return workingDir.resolve("%s.%s".formatted(manifestFile, extension));
    }

    static {
        clients = new HashMap<String, KubernetesClient>();
        OBJECT_MAPPER = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.READ_ENUMS_USING_TO_STRING})).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY})).enable(new SerializationFeature[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING})).disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE})).enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).build()).setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.NON_EMPTY));
    }
}

