/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import org.apache.camel.Exchange;
import org.apache.camel.component.jclouds.JcloudsBlobStoreEndpoint;
import org.apache.camel.component.jclouds.JcloudsBlobStoreHelper;
import org.apache.camel.component.jclouds.JcloudsProducer;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.io.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsBlobStoreProducer
extends JcloudsProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsBlobStoreProducer.class);
    private final JcloudsBlobStoreEndpoint endpoint;
    private BlobStore blobStore;

    public JcloudsBlobStoreProducer(JcloudsBlobStoreEndpoint endpoint, BlobStore blobStore) {
        super(endpoint);
        this.blobStore = blobStore;
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        String container = this.endpoint.getContainer();
        String locationId = this.endpoint.getLocationId();
        JcloudsBlobStoreHelper.ensureContainerExists(this.blobStore, container, locationId);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String container = this.getContainerName(exchange);
        String blobName = this.getBlobName(exchange);
        String operation = this.getOperation(exchange);
        LOG.trace("Processing {} operation on '{}'", (Object)operation, (Object)(container + "/" + blobName));
        if ("CamelJcloudsGet".equals(operation)) {
            exchange.getOut().setBody((Object)JcloudsBlobStoreHelper.readBlob(this.blobStore, container, blobName));
        } else {
            Payload body = (Payload)exchange.getIn().getBody(Payload.class);
            JcloudsBlobStoreHelper.writeBlob(this.blobStore, container, blobName, body);
        }
    }

    protected String getBlobName(Exchange exchange) {
        String blobName = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getBlobName();
        if (exchange.getIn().getHeader("CamelJcloudsBlobName") != null) {
            blobName = (String)exchange.getIn().getHeader("CamelJcloudsBlobName");
        }
        return blobName;
    }

    protected String getContainerName(Exchange exchange) {
        String containerName = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getContainer();
        if (exchange.getIn().getHeader("CamelJcloudsContainerName") != null) {
            containerName = (String)exchange.getIn().getHeader("CamelJcloudsContainerName");
        }
        return containerName;
    }

    public String getOperation(Exchange exchange) {
        String operation = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getOperation();
        if (exchange.getIn().getHeader("CamelJcloudsOperation") != null) {
            operation = (String)exchange.getIn().getHeader("CamelJcloudsOperation");
        }
        return operation;
    }

    public String getLocationId(Exchange exchange) {
        String operation = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getLocationId();
        if (exchange.getIn().getHeader("CamelJcloudsLocationId") != null) {
            operation = (String)exchange.getIn().getHeader("CamelJcloudsLocationId");
        }
        return operation;
    }
}

