/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.StreamSourceCache;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.io.payloads.StringPayload;

@Converter
public final class JcloudsPayloadConverter {
    private JcloudsPayloadConverter() {
    }

    @Converter
    public static Payload toPayload(byte[] bytes) {
        return new ByteArrayPayload(bytes);
    }

    @Converter
    public static Payload toPayload(String str) {
        return new StringPayload(str);
    }

    @Converter
    public static Payload toPayload(File file) {
        return new FilePayload(file);
    }

    protected static Payload setContentMetadata(Payload payload, Exchange exchange) {
        if (exchange == null) {
            return payload;
        }
        String contentType = (String)exchange.getIn().getHeader("Content-Type", String.class);
        String contentEncoding = (String)exchange.getIn().getHeader("Content-Encoding", String.class);
        String contentDisposition = (String)exchange.getIn().getHeader("CamelJcloudsContentDisposition", String.class);
        String contentLanguage = (String)exchange.getIn().getHeader("CamelJcloudsContentLanguage", String.class);
        Date payloadExpires = (Date)exchange.getIn().getHeader("CamelJcloudsPayloadExpires", Date.class);
        if (ObjectHelper.isNotEmpty((Object)contentType)) {
            payload.getContentMetadata().setContentType(contentType);
        }
        if (ObjectHelper.isNotEmpty((Object)contentEncoding)) {
            payload.getContentMetadata().setContentEncoding(contentEncoding);
        }
        if (ObjectHelper.isNotEmpty((Object)contentDisposition)) {
            payload.getContentMetadata().setContentDisposition(contentDisposition);
        }
        if (ObjectHelper.isNotEmpty((Object)contentLanguage)) {
            payload.getContentMetadata().setContentLanguage(contentLanguage);
        }
        if (ObjectHelper.isNotEmpty((Object)payloadExpires)) {
            payload.getContentMetadata().setExpires(payloadExpires);
        }
        return payload;
    }

    @Converter
    public static Payload toPayload(InputStream is, Exchange exchange) throws IOException {
        if (is.markSupported()) {
            InputStreamPayload payload = new InputStreamPayload(is);
            long contentLength = ByteStreams.length((InputSupplier)payload);
            is.reset();
            payload.getContentMetadata().setContentLength(Long.valueOf(contentLength));
            return payload;
        }
        CachedOutputStream cos = new CachedOutputStream(exchange);
        IOHelper.copy((InputStream)is, (OutputStream)cos);
        return JcloudsPayloadConverter.toPayload(cos.getWrappedInputStream(), exchange);
    }

    @Converter
    public static Payload toPayload(StreamSource source, Exchange exchange) throws IOException {
        return JcloudsPayloadConverter.toPayload(new StreamSourceCache(source, exchange), exchange);
    }

    @Converter
    public static Payload toPayload(final StreamSourceCache cache, Exchange exchange) throws IOException {
        long contentLength = ByteStreams.length((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return cache.getInputStream();
            }
        });
        cache.reset();
        InputStreamPayload payload = new InputStreamPayload(cache.getInputStream());
        payload.getContentMetadata().setContentLength(Long.valueOf(contentLength));
        JcloudsPayloadConverter.setContentMetadata((Payload)payload, exchange);
        return payload;
    }

    @FallbackConverter
    public static <T extends Payload> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) throws IOException {
        Class<?> genericFileType;
        TypeConverter converter;
        GenericFile genericFile;
        Class<?> sourceType = value.getClass();
        if (GenericFile.class.isAssignableFrom(sourceType) && (genericFile = (GenericFile)value).getFile() != null && (converter = registry.lookup(Payload.class, genericFileType = genericFile.getFile().getClass())) != null) {
            return (T)((Payload)converter.convertTo(Payload.class, genericFile.getFile()));
        }
        return null;
    }
}

