/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.apache.camel.util.IOHelper;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JcloudsBlobStoreHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsBlobStoreHelper.class);

    private JcloudsBlobStoreHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBlob(BlobStore blobStore, String container, String blobName, Object payload) {
        if (blobName != null && payload != null) {
            Blob blob = blobStore.blobBuilder(blobName).build();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(baos);
                oos.writeObject(payload);
                blob.setPayload(baos.toByteArray());
                blobStore.putBlob(container, blob);
            }
            catch (IOException e) {
                try {
                    LOG.error("Error while writing blob", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(oos);
                    IOHelper.close((Closeable)baos);
                    throw throwable;
                }
                IOHelper.close((Closeable)oos);
                IOHelper.close((Closeable)baos);
            }
            IOHelper.close((Closeable)oos);
            IOHelper.close((Closeable)baos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object readBlob(BlobStore blobStore, String container, String blobName, final ClassLoader classLoader) {
        Object result = null;
        ObjectInputStream ois = null;
        blobStore.createContainerInLocation(null, container);
        InputStream is = blobStore.getBlob(container, blobName).getPayload().getInput();
        try {
            ois = new ObjectInputStream(is){

                @Override
                public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    try {
                        return classLoader.loadClass(desc.getName());
                    }
                    catch (Exception exception) {
                        return super.resolveClass(desc);
                    }
                }
            };
            result = ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
            IOHelper.close((Closeable)ois);
            IOHelper.close((Closeable)is);
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOHelper.close(ois);
                    IOHelper.close((Closeable)is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)ois);
            IOHelper.close((Closeable)is);
        }
        IOHelper.close((Closeable)ois);
        IOHelper.close((Closeable)is);
        return result;
    }
}

