/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.jclouds.JcloudsBlobStoreEndpoint;
import org.apache.camel.component.jclouds.JcloudsBlobStoreHelper;
import org.apache.camel.component.jclouds.JcloudsConsumer;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsBlobStoreConsumer
extends JcloudsConsumer
implements BatchConsumer,
ShutdownAware {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsBlobStoreConsumer.class);
    private final JcloudsBlobStoreEndpoint endpoint;
    private final String container;
    private final BlobStore blobStore;
    private int maxMessagesPerPoll = 10;
    private volatile ShutdownRunningTask shutdownRunningTask;
    private volatile int pendingExchanges;

    public JcloudsBlobStoreConsumer(JcloudsBlobStoreEndpoint endpoint, Processor processor, BlobStore blobStore) {
        super(endpoint, processor);
        this.blobStore = blobStore;
        this.endpoint = endpoint;
        this.container = endpoint.getContainer();
    }

    @Override
    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        LinkedList<Exchange> queue = new LinkedList<Exchange>();
        ListContainerOptions opt = new ListContainerOptions();
        for (StorageMetadata md : this.blobStore.list(this.container, opt.maxResults(this.maxMessagesPerPoll))) {
            String blobName = md.getName();
            Object body = JcloudsBlobStoreHelper.readBlob(this.blobStore, this.container, blobName, Thread.currentThread().getContextClassLoader());
            Exchange exchange = this.endpoint.createExchange();
            exchange.getIn().setBody(body);
            exchange.setProperty("CamelJcloudsBlobName", (Object)blobName);
            queue.add(exchange);
        }
        return queue.isEmpty() ? 0 : this.processBatch(CastUtils.cast(queue));
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            exchange.addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    String blobName = (String)exchange.getProperty("CamelJcloudsBlobName");
                    JcloudsBlobStoreConsumer.this.blobStore.removeBlob(JcloudsBlobStoreConsumer.this.container, blobName);
                }

                public void onFailure(Exchange exchange) {
                }
            });
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            this.getProcessor().process(exchange);
        }
        return total;
    }

    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    public int getPendingExchangesSize() {
        int answer = ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask ? this.pendingExchanges : 0;
        if (answer == 0 && this.isPolling()) {
            this.log.trace("Currently polling so returning 1 as pending exchanges");
            answer = 1;
        }
        return answer;
    }

    public void prepareShutdown() {
    }
}

