/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import org.apache.camel.Exchange;
import org.apache.camel.component.jclouds.JcloudsBlobStoreEndpoint;
import org.apache.camel.component.jclouds.JcloudsBlobStoreHelper;
import org.apache.camel.component.jclouds.JcloudsEndpoint;
import org.apache.camel.component.jclouds.JcloudsProducer;
import org.jclouds.blobstore.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsBlobStoreProducer
extends JcloudsProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsBlobStoreProducer.class);
    private BlobStore blobStore;

    public JcloudsBlobStoreProducer(JcloudsEndpoint endpoint, BlobStore blobStore) {
        super(endpoint);
        this.blobStore = blobStore;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String container = this.getContainerName(exchange);
        String blobName = this.getBlobName(exchange);
        String operation = this.getOperation(exchange);
        LOG.trace("Processing {} operation on '{}'", (Object)operation, (Object)(container + "/" + blobName));
        Object body = exchange.getIn().getBody();
        if ("CamelJcloudsGet".equals(operation)) {
            exchange.getOut().setBody(JcloudsBlobStoreHelper.readBlob(this.blobStore, container, blobName, Thread.currentThread().getContextClassLoader()));
        } else {
            JcloudsBlobStoreHelper.writeBlob(this.blobStore, container, blobName, body);
        }
    }

    protected String getBlobName(Exchange exchange) {
        String blobName = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getBlobName();
        if (exchange.getIn().getHeader("CamelJcloudsBlobName") != null) {
            blobName = (String)exchange.getIn().getHeader("CamelJcloudsBlobName");
        }
        return blobName;
    }

    protected String getContainerName(Exchange exchange) {
        String containerName = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getContainer();
        if (exchange.getIn().getHeader("CamelJcloudsContainerName") != null) {
            containerName = (String)exchange.getIn().getHeader("CamelJcloudsContainerName");
        }
        return containerName;
    }

    public String getOperation(Exchange exchange) {
        String operation = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getOperation();
        if (exchange.getIn().getHeader("CamelJcloudsOperation") != null) {
            operation = (String)exchange.getIn().getHeader("CamelJcloudsOperation");
        }
        return operation;
    }
}

