/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jclouds.JcloudsBlobStoreEndpoint;
import org.apache.camel.component.jclouds.JcloudsComputeEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.compute.ComputeService;

public class JcloudsComponent
extends DefaultComponent {
    private List<BlobStore> blobStores;
    private List<ComputeService> computeServices;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        void var4_7;
        Object var4_4 = null;
        String[] uriParts = null;
        String endpointType = null;
        if (remaining != null && (uriParts = remaining.split(":")) != null && uriParts.length > 0) {
            endpointType = uriParts[0];
        }
        if ("blobstore".endsWith(endpointType)) {
            if (uriParts.length < 2) throw new Exception("Invalid Endpoint URI. It should contains a valid provider name");
            String provider = uriParts[1];
            BlobStore blobStore = this.getBlobStoreForProvider(provider);
            JcloudsBlobStoreEndpoint jcloudsBlobStoreEndpoint = new JcloudsBlobStoreEndpoint(uri, this, blobStore);
        } else if ("compute".endsWith(endpointType)) {
            if (uriParts.length < 2) throw new Exception("Invalid Endpoint URI. It should contains a valid provider name");
            String provider = uriParts[1];
            ComputeService computeService = this.getComputeServiceForProvider(provider);
            JcloudsComputeEndpoint jcloudsComputeEndpoint = new JcloudsComputeEndpoint(uri, this, computeService);
        }
        this.setProperties(var4_7, parameters);
        return var4_7;
    }

    protected BlobStore getBlobStoreForProvider(String provider) throws Exception {
        if (this.blobStores != null && !this.blobStores.isEmpty()) {
            for (BlobStore blobStore : this.blobStores) {
                if (!blobStore.getContext().getProviderSpecificContext().getId().equals(provider)) continue;
                return blobStore;
            }
            throw new Exception(String.format("No blobstore found for provider:%s", provider));
        }
        throw new Exception("No blobstore available.");
    }

    protected ComputeService getComputeServiceForProvider(String provider) throws Exception {
        if (this.computeServices != null && !this.computeServices.isEmpty()) {
            for (ComputeService computeService : this.computeServices) {
                if (!computeService.getContext().getProviderSpecificContext().getId().equals(provider)) continue;
                return computeService;
            }
            throw new Exception(String.format("No compute service found for provider:%s", provider));
        }
        throw new Exception("No compute service available.");
    }

    public List<BlobStore> getBlobStores() {
        return this.blobStores;
    }

    public void setBlobStores(List<BlobStore> blobStores) {
        this.blobStores = blobStores;
    }

    public List<ComputeService> getComputeServices() {
        return this.computeServices;
    }

    public void setComputeServices(List<ComputeService> computeServices) {
        this.computeServices = computeServices;
    }
}

