/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import com.google.common.base.Predicate;
import java.util.Set;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.component.jclouds.JcloudsComputeEndpoint;
import org.apache.camel.component.jclouds.JcloudsEndpoint;
import org.apache.camel.component.jclouds.JcloudsProducer;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.NodeMetadataImpl;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;

public class JcloudsComputeProducer
extends JcloudsProducer {
    private final ComputeService computeService;

    public JcloudsComputeProducer(JcloudsEndpoint endpoint, ComputeService computeService) {
        super(endpoint);
        this.computeService = computeService;
    }

    public JcloudsComputeEndpoint getEndpoint() {
        return (JcloudsComputeEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation = this.getOperation(exchange);
        if (operation == null) {
            throw new CamelException("Operation must be specified in the endpoitn URI or as a property on the exchange.");
        }
        if ("CamelJcloudsListNodes".equals(operation)) {
            this.listNodes(exchange);
        } else if ("CamelJcloudsListImages".equals(operation)) {
            this.listImages(exchange);
        } else if ("CamelJcloudsListHardware".equals(operation)) {
            this.listHardware(exchange);
        } else if ("CamelJcloudsRunScript".equals(operation)) {
            this.runScriptOnNode(exchange);
        } else if ("CamelJcloudsCreateNode".equals(operation)) {
            this.createNode(exchange);
        } else if ("CamelJcloudsDestroyNode".equals(operation)) {
            this.destroyNode(exchange);
        }
    }

    protected void createNode(Exchange exchange) throws CamelException {
        String group = this.getGroup(exchange);
        String imageId = this.getImageId(exchange);
        String locationId = this.getLocationId(exchange);
        String hardwareId = this.getHardwareId(exchange);
        if (group == null) {
            throw new CamelException("Group must be specific in the URI or as exchange property for the destroy node operation.");
        }
        TemplateBuilder builder = this.computeService.templateBuilder();
        builder.any();
        if (locationId != null) {
            builder.locationId(locationId);
        }
        if (imageId != null) {
            builder.imageId(imageId);
        }
        if (hardwareId != null) {
            builder.hardwareId(hardwareId);
        }
        try {
            Set nodeMetadatas = this.computeService.createNodesInGroup(group, 1, builder.build());
            exchange.getOut().setBody((Object)nodeMetadatas);
            exchange.getOut().setHeaders(exchange.getIn().getHeaders());
        }
        catch (RunNodesException e) {
            throw new CamelException("Error creating jclouds node.", (Throwable)e);
        }
    }

    protected void runScriptOnNode(Exchange exchange) throws CamelException {
        String script = (String)exchange.getIn().getBody(String.class);
        String nodeId = this.getNodeId(exchange);
        String user = this.getUser(exchange);
        LoginCredentials credentials = null;
        if (user != null) {
            credentials = LoginCredentials.builder().user(user).build();
        }
        ExecResponse execResponse = null;
        execResponse = credentials == null ? this.computeService.runScriptOnNode(nodeId, script) : this.computeService.runScriptOnNode(nodeId, script, RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)credentials).runAsRoot(false));
        if (execResponse == null) {
            throw new CamelException("Failed to receive response for run script operation.");
        }
        exchange.setProperty("CamelJcloudsRunScriptError", (Object)execResponse.getError());
        exchange.setProperty("CamelJcloudsRunScriptErrorCode", (Object)execResponse.getExitCode());
        exchange.getOut().setBody((Object)execResponse.getOutput());
    }

    protected void destroyNode(Exchange exchange) throws CamelException {
        Predicate<NodeMetadata> predicate = this.getNodePredicate(exchange);
        this.computeService.destroyNodesMatching(predicate);
    }

    protected void listNodes(Exchange exchange) throws CamelException {
        Predicate<ComputeMetadata> predicate = this.getComputePredicate(exchange);
        Set computeMetadatas = this.computeService.listNodesDetailsMatching(predicate);
        exchange.getOut().setBody((Object)computeMetadatas);
    }

    protected void listImages(Exchange exchange) throws CamelException {
        Set images = this.computeService.listImages();
        exchange.getOut().setBody((Object)images);
    }

    protected void listHardware(Exchange exchange) throws CamelException {
        Set hardwareProfiles = this.computeService.listHardwareProfiles();
        exchange.getOut().setBody((Object)hardwareProfiles);
    }

    public Predicate<ComputeMetadata> getComputePredicate(final Exchange exchange) {
        final String nodeId = this.getNodeId(exchange);
        String imageId = this.getImageId(exchange);
        String group = this.getGroup(exchange);
        NodeState queryState = this.getNodeState(exchange);
        Predicate<ComputeMetadata> predicate = new Predicate<ComputeMetadata>(){

            public boolean apply(ComputeMetadata metadata) {
                Predicate<NodeMetadata> nodeMetadataPredicate;
                if (nodeId != null && !nodeId.equals(metadata.getId())) {
                    return false;
                }
                return !(metadata instanceof NodeMetadataImpl) || (nodeMetadataPredicate = JcloudsComputeProducer.this.getNodePredicate(exchange)).apply((Object)((NodeMetadataImpl)metadata));
            }
        };
        return predicate;
    }

    public Predicate<NodeMetadata> getNodePredicate(Exchange exchange) {
        final String nodeId = this.getNodeId(exchange);
        final String imageId = this.getImageId(exchange);
        final String group = this.getGroup(exchange);
        final NodeState queryState = this.getNodeState(exchange);
        Predicate<NodeMetadata> predicate = new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata metadata) {
                if (nodeId != null && !nodeId.equals(metadata.getId())) {
                    return false;
                }
                if (imageId != null && !imageId.equals(metadata.getImageId())) {
                    return false;
                }
                if (queryState != null && !queryState.equals((Object)metadata.getState())) {
                    return false;
                }
                return group == null || group.equals(metadata.getGroup());
            }
        };
        return predicate;
    }

    public String getOperation(Exchange exchange) {
        String operation = this.getEndpoint().getOperation();
        if (exchange.getIn().getHeader("CamelJcloudsOperation") != null) {
            operation = (String)exchange.getIn().getHeader("CamelJcloudsOperation");
        }
        return operation;
    }

    public NodeState getNodeState(Exchange exchange) {
        Object nodeState = null;
        String state = this.getEndpoint().getNodeState();
        if (state != null) {
            nodeState = NodeState.valueOf((String)state);
        }
        if (exchange.getIn().getHeader("CamelJcloudsNodeState") != null) {
            Object stateHeader = exchange.getIn().getHeader("CamelJcloudsNodeState");
            nodeState = stateHeader == null ? null : (stateHeader instanceof NodeState ? (NodeState)stateHeader : NodeState.valueOf((String)String.valueOf(stateHeader)));
        }
        return nodeState;
    }

    protected String getImageId(Exchange exchange) {
        String imageId = this.getEndpoint().getImageId();
        if (exchange.getIn().getHeader("CamelJcloudsImageId") != null) {
            imageId = (String)exchange.getIn().getHeader("CamelJcloudsImageId");
        }
        return imageId;
    }

    protected String getHardwareId(Exchange exchange) {
        String hardwareId = this.getEndpoint().getHardwareId();
        if (exchange.getIn().getHeader("CamelJcloudsHardwareId") != null) {
            hardwareId = (String)exchange.getIn().getHeader("CamelJcloudsHardwareId");
        }
        return hardwareId;
    }

    protected String getLocationId(Exchange exchange) {
        String locationId = this.getEndpoint().getLocationId();
        if (exchange.getIn().getHeader("CamelJcloudsLocationId") != null) {
            locationId = (String)exchange.getIn().getHeader("CamelJcloudsLocationId");
        }
        return locationId;
    }

    protected String getNodeId(Exchange exchange) {
        String nodeId = this.getEndpoint().getNodeId();
        if (exchange.getIn().getHeader("CamelJcloudsNodeId") != null) {
            nodeId = (String)exchange.getIn().getHeader("CamelJcloudsNodeId");
        }
        return nodeId;
    }

    protected String getGroup(Exchange exchange) {
        String group = this.getEndpoint().getGroup();
        if (exchange.getIn().getHeader("CamelJcloudsGroup") != null) {
            group = (String)exchange.getIn().getHeader("CamelJcloudsGroup");
        }
        return group;
    }

    protected String getUser(Exchange exchange) {
        String user = this.getEndpoint().getUser();
        if (exchange.getIn().getHeader("CamelJcloudsUser") != null) {
            user = (String)exchange.getIn().getHeader("CamelJcloudsUser");
        }
        return user;
    }
}

