package org.apache.camel.component.jclouds;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class JcloudsPayloadConverterLoader implements TypeConverterLoader {


    static abstract class BaseTypeConverter extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public boolean allowNull() {
            return allowNull;
        }

        @Override
        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T) doConvert(exchange, value);
            } catch (TypeConversionException e) {
                throw e;
            } catch (Exception e) {
                throw new TypeConversionException(value, type, e);
            }
        }
        protected abstract Object doConvert(Exchange exchange, Object value) throws Exception;
    };

    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap<>(6);

    public JcloudsPayloadConverterLoader() {
    }

    private void registerConverters() {
        converters.put(org.jclouds.io.Payload.class, byte[].class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.jclouds.JcloudsPayloadConverter.toPayload((byte[]) value);
            }
        });
        converters.put(org.jclouds.io.Payload.class, java.io.File.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.jclouds.JcloudsPayloadConverter.toPayload((java.io.File) value);
            }
        });
        converters.put(org.jclouds.io.Payload.class, java.io.InputStream.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.jclouds.JcloudsPayloadConverter.toPayload((java.io.InputStream) value, exchange);
            }
        });
        converters.put(org.jclouds.io.Payload.class, java.lang.String.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.jclouds.JcloudsPayloadConverter.toPayload((java.lang.String) value, exchange);
            }
        });
        converters.put(org.jclouds.io.Payload.class, org.apache.camel.converter.stream.StreamSourceCache.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.jclouds.JcloudsPayloadConverter.toPayload((org.apache.camel.converter.stream.StreamSourceCache) value, exchange);
            }
        });
        converters.put(org.jclouds.io.Payload.class, javax.xml.transform.stream.StreamSource.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.jclouds.JcloudsPayloadConverter.toPayload((javax.xml.transform.stream.StreamSource) value, exchange);
            }
        });
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters();
        converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, c));
        registry.addFallbackTypeConverter(new TypeConverterSupport() {
            @Override
            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return (T) org.apache.camel.component.jclouds.JcloudsPayloadConverter.convertTo(type, exchange, value, registry);
                } catch (TypeConversionException e) {
                    throw e;
                } catch (Exception e) {
                    throw new TypeConversionException(value, type, e);
                }
            }
        }, false);
    }

}
