/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.jclouds.JcloudsPayloadConverter;
import org.apache.camel.converter.stream.StreamSourceCache;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;
import org.jclouds.io.Payload;

public class JcloudsPayloadConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(6);

    private void registerConverters() {
        this.converters.put(Payload.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return JcloudsPayloadConverter.toPayload((byte[])value);
            }
        });
        this.converters.put(Payload.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return JcloudsPayloadConverter.toPayload((File)value);
            }
        });
        this.converters.put(Payload.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return JcloudsPayloadConverter.toPayload((InputStream)value, exchange);
            }
        });
        this.converters.put(Payload.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return JcloudsPayloadConverter.toPayload((String)value, exchange);
            }
        });
        this.converters.put(Payload.class, StreamSourceCache.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return JcloudsPayloadConverter.toPayload((StreamSourceCache)value, exchange);
            }
        });
        this.converters.put(Payload.class, StreamSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return JcloudsPayloadConverter.toPayload((StreamSource)value, exchange);
            }
        });
    }

    public void load(final TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
        registry.addFallbackTypeConverter((TypeConverter)new TypeConverterSupport(){

            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return JcloudsPayloadConverter.convertTo(type, exchange, value, registry);
                }
                catch (TypeConversionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TypeConversionException(value, type, (Throwable)e);
                }
            }
        }, false);
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

