/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.jclouds.JcloudsPayloadConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.util.xml.StreamSourceCache;
import org.jclouds.io.Payload;

public class JcloudsPayloadConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, Payload.class, byte[].class, false, (type, exchange, value) -> JcloudsPayloadConverter.toPayload((byte[])value));
        this.addTypeConverter(registry, Payload.class, File.class, false, (type, exchange, value) -> JcloudsPayloadConverter.toPayload((File)value));
        this.addTypeConverter(registry, Payload.class, InputStream.class, false, (type, exchange, value) -> JcloudsPayloadConverter.toPayload((InputStream)value, exchange));
        this.addTypeConverter(registry, Payload.class, String.class, false, (type, exchange, value) -> JcloudsPayloadConverter.toPayload((String)value, exchange));
        this.addTypeConverter(registry, Payload.class, StreamSourceCache.class, false, (type, exchange, value) -> JcloudsPayloadConverter.toPayload((StreamSourceCache)value, exchange));
        this.addTypeConverter(registry, Payload.class, StreamSource.class, false, (type, exchange, value) -> JcloudsPayloadConverter.toPayload((StreamSource)value, exchange));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        this.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> JcloudsPayloadConverter.convertTo(type, exchange, value, registry));
    }

    private void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

