/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JcloudsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":command:providerId";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "jclouds".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "command", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "providerId", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(18);
        props.add("blobName");
        props.add("container");
        props.add("imageId");
        props.add("synchronous");
        props.add("exchangePattern");
        props.add("directory");
        props.add("command");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("hardwareId");
        props.add("nodeState");
        props.add("providerId");
        props.add("locationId");
        props.add("exceptionHandler");
        props.add("nodeId");
        props.add("operation");
        props.add("user");
        props.add("group");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

