/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.Service;
import org.apache.camel.component.jetty.CamelContinuationServlet;
import org.apache.camel.component.jetty.CamelFilterWrapper;
import org.apache.camel.component.jetty.CamelHttpClient;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.component.jetty.JettyRestHttpBinding;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpConfiguration;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpRestHeaderFilterStrategy;
import org.apache.camel.http.common.HttpRestServletResolveConsumerStrategy;
import org.apache.camel.http.common.ServletResolveConsumerStrategy;
import org.apache.camel.http.common.UrlRewrite;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.spi.RestProducerFactoryHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.servlets.MultiPartFilter;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JettyHttpComponent
extends HttpCommonComponent
implements RestConsumerFactory,
RestApiConsumerFactory,
RestProducerFactory,
SSLContextParametersAware {
    public static final String TMP_DIR = "CamelJettyTempDir";
    protected static final HashMap<String, ConnectorRef> CONNECTORS = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpComponent.class);
    private static final String JETTY_SSL_KEYSTORE = "org.eclipse.jetty.ssl.keystore";
    private static final String JETTY_SSL_KEYPASSWORD = "org.eclipse.jetty.ssl.keypassword";
    private static final String JETTY_SSL_PASSWORD = "org.eclipse.jetty.ssl.password";
    protected String sslKeyPassword;
    protected String sslPassword;
    protected String sslKeystore;
    protected Map<Integer, Connector> sslSocketConnectors;
    protected Map<Integer, Connector> socketConnectors;
    protected Map<String, Object> sslSocketConnectorProperties;
    protected Map<String, Object> socketConnectorProperties;
    protected Integer httpClientMinThreads;
    protected Integer httpClientMaxThreads;
    protected Integer minThreads;
    protected Integer maxThreads;
    protected ThreadPool threadPool;
    protected MBeanContainer mbContainer;
    protected boolean enableJmx;
    protected JettyHttpBinding jettyHttpBinding;
    protected Long continuationTimeout;
    protected boolean useContinuation = true;
    protected SSLContextParameters sslContextParameters;
    protected boolean useGlobalSslContextParameters;
    protected Integer requestBufferSize;
    protected Integer requestHeaderSize;
    protected Integer responseBufferSize;
    protected Integer responseHeaderSize;
    protected String proxyHost;
    protected ErrorHandler errorHandler;
    protected boolean useXForwardedForHeader;
    private Integer proxyPort;
    private boolean sendServerVersion = true;

    public JettyHttpComponent() {
        super(JettyHttpEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        List handlerList = this.resolveAndRemoveReferenceListParameter(parameters, "handlers", Handler.class);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        JettyHttpBinding jettyBinding = (JettyHttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "jettyHttpBindingRef", JettyHttpBinding.class);
        Boolean enableJmx = (Boolean)this.getAndRemoveParameter(parameters, "enableJmx", Boolean.class);
        Boolean enableMultipartFilter = (Boolean)this.getAndRemoveParameter(parameters, "enableMultipartFilter", Boolean.class, true);
        Filter multipartFilter = (Filter)this.resolveAndRemoveReferenceParameter(parameters, "multipartFilterRef", Filter.class);
        ArrayList<CrossOriginFilter> filters = this.resolveAndRemoveReferenceListParameter(parameters, "filtersRef", Filter.class);
        Boolean enableCors = (Boolean)this.getAndRemoveParameter(parameters, "enableCORS", Boolean.class, false);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        UrlRewrite urlRewrite = (UrlRewrite)this.resolveAndRemoveReferenceParameter(parameters, "urlRewrite", UrlRewrite.class);
        SSLContextParameters sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParameters", SSLContextParameters.class);
        SSLContextParameters ssl = sslContextParameters != null ? sslContextParameters : this.sslContextParameters;
        ssl = ssl != null ? ssl : this.retrieveGlobalSslContextParameters();
        String proxyHost = (String)this.getAndRemoveParameter(parameters, "proxyHost", String.class, this.getProxyHost());
        Integer proxyPort = (Integer)this.getAndRemoveParameter(parameters, "proxyPort", Integer.class, this.getProxyPort());
        Integer httpClientMinThreads = (Integer)this.getAndRemoveParameter(parameters, "httpClientMinThreads", Integer.class, this.httpClientMinThreads);
        Integer httpClientMaxThreads = (Integer)this.getAndRemoveParameter(parameters, "httpClientMaxThreads", Integer.class, this.httpClientMaxThreads);
        HttpClient httpClient = (HttpClient)this.resolveAndRemoveReferenceParameter(parameters, "httpClient", HttpClient.class);
        Boolean async = (Boolean)this.getAndRemoveParameter(parameters, "async", Boolean.class);
        Map httpClientParameters = IntrospectionSupport.extractProperties(parameters, (String)"httpClient.");
        Map filterInitParameters = IntrospectionSupport.extractStringProperties((Map)IntrospectionSupport.extractProperties(parameters, (String)"filterInit."));
        String address = remaining;
        URI addressUri = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)address));
        URI endpointUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        URI httpUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        String scheme = StringHelper.before((String)uri, (String)":");
        endpointUri = new URI(scheme + ":" + endpointUri);
        JettyHttpEndpoint endpoint = this.createEndpoint(endpointUri, httpUri);
        if (async != null) {
            endpoint.setAsync(async);
        }
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        if (proxyHost != null) {
            endpoint.setProxyHost(proxyHost);
            endpoint.setProxyPort(proxyPort);
        }
        if (urlRewrite != null) {
            this.getCamelContext().addService((Object)urlRewrite);
            endpoint.setUrlRewrite(urlRewrite);
        }
        if (httpClientParameters != null && !httpClientParameters.isEmpty()) {
            endpoint.setHttpClientParameters(httpClientParameters);
        }
        if (filterInitParameters != null && !filterInitParameters.isEmpty()) {
            endpoint.setFilterInitParameters(filterInitParameters);
        }
        if (handlerList.size() > 0) {
            endpoint.setHandlers(handlerList);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setBinding(binding);
        }
        if (jettyBinding == null) {
            jettyBinding = this.getJettyHttpBinding();
        }
        if (jettyBinding != null) {
            endpoint.setJettyBinding(jettyBinding);
        }
        if (enableJmx != null) {
            endpoint.setEnableJmx(enableJmx);
        } else {
            endpoint.setEnableJmx(this.isEnableJmx());
        }
        endpoint.setEnableMultipartFilter(enableMultipartFilter);
        if (multipartFilter != null) {
            endpoint.setMultipartFilter(multipartFilter);
            endpoint.setEnableMultipartFilter(true);
        }
        if (enableCors.booleanValue()) {
            endpoint.setEnableCORS(enableCors);
            if (filters == null) {
                filters = new ArrayList<CrossOriginFilter>(1);
            }
            filters.add(new CrossOriginFilter());
        }
        if (filters != null) {
            endpoint.setFilters((List<Filter>)filters);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        if (ssl != null) {
            endpoint.setSslContextParameters(ssl);
        }
        if (httpClientMinThreads != null) {
            endpoint.setHttpClientMinThreads(httpClientMinThreads);
        }
        if (httpClientMaxThreads != null) {
            endpoint.setHttpClientMaxThreads(httpClientMaxThreads);
        }
        if (httpClient != null) {
            endpoint.setHttpClient(httpClient);
        }
        endpoint.setSendServerVersion(this.isSendServerVersion());
        this.setProperties((Object)endpoint, parameters);
        httpUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        endpoint.setHttpUri(httpUri);
        return endpoint;
    }

    protected abstract JettyHttpEndpoint createEndpoint(URI var1, URI var2) throws URISyntaxException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canConnect(HttpConsumer consumer) throws Exception {
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef != null) {
                for (Map.Entry entry : connectorRef.servlet.getConsumers().entrySet()) {
                    boolean sameContext;
                    String path = ((HttpConsumer)entry.getValue()).getPath();
                    CamelContext camelContext = ((HttpConsumer)entry.getValue()).getEndpoint().getCamelContext();
                    if (!consumer.getPath().equals(path) || (sameContext = consumer.getEndpoint().getCamelContext() == camelContext)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(HttpConsumer consumer) throws Exception {
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef == null) {
                Server server = this.createServer();
                Connector connector = this.getConnector(server, endpoint);
                if ("localhost".equalsIgnoreCase(endpoint.getHttpUri().getHost())) {
                    LOG.warn("You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)? " + (Object)((Object)endpoint));
                }
                if (endpoint.isEnableJmx()) {
                    this.enableJmx(server);
                }
                server.addConnector(connector);
                connectorRef = new ConnectorRef(this.getCamelContext(), server, connector, this.createServletForConnector(server, connector, endpoint.getHandlers(), endpoint));
                if (endpoint.isSessionSupport()) {
                    this.enableSessionSupport(connectorRef.server, connectorKey);
                }
                connectorRef.server.start();
                LOG.debug("Adding connector key: {} -> {}", (Object)connectorKey, (Object)connectorRef);
                CONNECTORS.put(connectorKey, connectorRef);
            } else {
                LOG.debug("Using existing connector key: {} -> {}", (Object)connectorKey, (Object)connectorRef);
                if (endpoint.getHandlers() != null && !endpoint.getHandlers().isEmpty()) {
                    ArrayList<Handler> newHandlers;
                    boolean changed;
                    List<Object> existingHandlers = new ArrayList();
                    if (connectorRef.server.getHandlers() != null && connectorRef.server.getHandlers().length > 0) {
                        existingHandlers = Arrays.asList(connectorRef.server.getHandlers());
                    }
                    boolean bl = changed = !existingHandlers.containsAll(newHandlers = new ArrayList<Handler>(endpoint.getHandlers())) && !newHandlers.containsAll(existingHandlers);
                    if (changed) {
                        LOG.debug("Restarting Jetty server due to adding new Jetty Handlers: {}", newHandlers);
                        connectorRef.server.stop();
                        this.addJettyHandlers(connectorRef.server, endpoint.getHandlers());
                        connectorRef.server.start();
                    }
                }
                connectorRef.increment();
            }
            if (endpoint.isSessionSupport()) {
                this.enableSessionSupport(connectorRef.server, connectorKey);
            }
            if (endpoint.isEnableMultipartFilter()) {
                this.enableMultipartFilter(endpoint, connectorRef.server, connectorKey);
            }
            if (endpoint.getFilters() != null && endpoint.getFilters().size() > 0) {
                this.setFilters(endpoint, connectorRef.server, connectorKey);
            }
            connectorRef.servlet.connect(consumer);
        }
    }

    private void enableJmx(Server server) {
        MBeanContainer containerToRegister = this.getMbContainer();
        if (containerToRegister != null) {
            LOG.info("Jetty JMX Extensions is enabled");
            this.addServerMBean(server);
        }
    }

    private void enableSessionSupport(Server server, String connectorKey) throws Exception {
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        if (context.getSessionHandler() == null) {
            SessionHandler sessionHandler = new SessionHandler();
            if (context.isStarted()) {
                throw new IllegalStateException("Server has already been started. Cannot enabled sessionSupport on " + connectorKey);
            }
            context.setSessionHandler(sessionHandler);
        }
    }

    private void setFilters(JettyHttpEndpoint endpoint, Server server, String connectorKey) {
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        List<Filter> filters = endpoint.getFilters();
        for (Filter filter : filters) {
            FilterHolder filterHolder = new FilterHolder();
            if (endpoint.getFilterInitParameters() != null) {
                filterHolder.setInitParameters(endpoint.getFilterInitParameters());
            }
            filterHolder.setFilter((Filter)new CamelFilterWrapper(filter));
            String pathSpec = endpoint.getPath();
            if (pathSpec == null || "".equals(pathSpec)) {
                pathSpec = "/";
            }
            if (endpoint.isMatchOnUriPrefix()) {
                pathSpec = pathSpec.endsWith("/") ? pathSpec + "*" : pathSpec + "/*";
            }
            this.addFilter(context, filterHolder, pathSpec);
        }
    }

    private void addFilter(ServletContextHandler context, FilterHolder filterHolder, String pathSpec) {
        context.getServletHandler().addFilterWithMapping(filterHolder, pathSpec, 0);
    }

    private void enableMultipartFilter(HttpCommonEndpoint endpoint, Server server, String connectorKey) throws Exception {
        Filter filter;
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        CamelContext camelContext = this.getCamelContext();
        FilterHolder filterHolder = new FilterHolder();
        filterHolder.setInitParameter("deleteFiles", "true");
        if (ObjectHelper.isNotEmpty((Object)camelContext.getProperty(TMP_DIR))) {
            File file = new File(camelContext.getProperty(TMP_DIR));
            if (!file.isDirectory()) {
                throw new RuntimeCamelException("The temp file directory of camel-jetty is not exists, please recheck it with directory name :" + (String)camelContext.getProperties().get(TMP_DIR));
            }
            context.setAttribute("javax.servlet.context.tempdir", (Object)file);
        }
        if ((filter = ((JettyHttpEndpoint)endpoint).getMultipartFilter()) == null) {
            filter = new MultiPartFilter();
        }
        filterHolder.setFilter((Filter)new CamelFilterWrapper(filter));
        String pathSpec = endpoint.getPath();
        if (pathSpec == null || "".equals(pathSpec)) {
            pathSpec = "/";
        }
        if (endpoint.isMatchOnUriPrefix()) {
            pathSpec = pathSpec.endsWith("/") ? pathSpec + "*" : pathSpec + "/*";
        }
        this.addFilter(context, filterHolder, pathSpec);
        LOG.debug("using multipart filter implementation " + filter.getClass().getName() + " for path " + pathSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(HttpConsumer consumer) throws Exception {
        HttpCommonEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef != null) {
                connectorRef.servlet.disconnect(consumer);
                if (connectorRef.decrement() == 0) {
                    connectorRef.server.removeConnector(connectorRef.connector);
                    connectorRef.connector.stop();
                    connectorRef.server.stop();
                    CONNECTORS.remove(connectorKey);
                    if (this.mbContainer != null) {
                        this.removeServerMBean(connectorRef.server);
                    }
                }
            }
        }
    }

    private String getConnectorKey(HttpCommonEndpoint endpoint) {
        return endpoint.getProtocol() + ":" + endpoint.getHttpUri().getHost() + ":" + endpoint.getPort();
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    @Metadata(description="The key password, which is used to access the certificate's key entry in the keystore (this is the same password that is supplied to the keystore command's -keypass option).", label="security", secret=true)
    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    @Metadata(description="The ssl password, which is required to access the keystore file (this is the same password that is supplied to the keystore command's -storepass option).", label="security", secret=true)
    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    @Metadata(description="Specifies the location of the Java keystore file, which contains the Jetty server's own X.509 certificate in a key entry.", label="security", secret=true)
    public void setKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getKeystore() {
        return this.sslKeystore;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Metadata(description="This option is used to set the ErrorHandler that Jetty server uses.", label="advanced")
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected Connector getConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector connector = "https".equals(endpoint.getProtocol()) ? this.getSslSocketConnector(server, endpoint) : this.getSocketConnector(server, endpoint);
        return connector;
    }

    protected Connector getSocketConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector answer = null;
        if (this.socketConnectors != null) {
            answer = this.socketConnectors.get(endpoint.getPort());
        }
        if (answer == null) {
            answer = this.createConnector(server, endpoint);
        }
        return answer;
    }

    protected Connector getSslSocketConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector answer = null;
        if (this.sslSocketConnectors != null) {
            answer = this.sslSocketConnectors.get(endpoint.getPort());
        }
        if (answer == null) {
            answer = this.createConnector(server, endpoint);
        }
        return answer;
    }

    protected Connector createConnector(Server server, JettyHttpEndpoint endpoint) {
        SslContextFactory sslcf = null;
        SSLContextParameters endpointSslContextParameters = endpoint.getSslContextParameters();
        if (endpointSslContextParameters != null) {
            try {
                sslcf = this.createSslContextFactory(endpointSslContextParameters);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        } else if ("https".equals(endpoint.getProtocol())) {
            sslcf = new SslContextFactory();
            String keystoreProperty = System.getProperty(JETTY_SSL_KEYSTORE);
            if (keystoreProperty != null) {
                sslcf.setKeyStorePath(keystoreProperty);
            } else if (this.sslKeystore != null) {
                sslcf.setKeyStorePath(this.sslKeystore);
            }
            String keystorePassword = System.getProperty(JETTY_SSL_KEYPASSWORD);
            if (keystorePassword != null) {
                sslcf.setKeyManagerPassword(keystorePassword);
            } else if (this.sslKeyPassword != null) {
                sslcf.setKeyManagerPassword(this.sslKeyPassword);
            }
            String password = System.getProperty(JETTY_SSL_PASSWORD);
            if (password != null) {
                sslcf.setKeyStorePassword(password);
            } else if (this.sslPassword != null) {
                sslcf.setKeyStorePassword(this.sslPassword);
            }
        }
        return this.createConnectorJettyInternal(server, endpoint, sslcf);
    }

    protected abstract AbstractConnector createConnectorJettyInternal(Server var1, JettyHttpEndpoint var2, SslContextFactory var3);

    private SslContextFactory createSslContextFactory(SSLContextParameters ssl) throws GeneralSecurityException, IOException {
        String[] arr;
        String[] arr2;
        SslContextFactory answer = new SslContextFactory();
        if (ssl != null) {
            answer.setSslContext(ssl.createSSLContext(this.getCamelContext()));
        }
        if (ssl != null && ssl.getCipherSuitesFilter() != null) {
            List includeCiphers = ssl.getCipherSuitesFilter().getInclude();
            if (includeCiphers != null && !includeCiphers.isEmpty()) {
                arr2 = includeCiphers.toArray(new String[includeCiphers.size()]);
                answer.setIncludeCipherSuites(arr2);
            } else {
                answer.setIncludeCipherSuites(new String[]{".*"});
            }
            List excludeCiphers = ssl.getCipherSuitesFilter().getExclude();
            if (excludeCiphers != null && !excludeCiphers.isEmpty()) {
                arr = excludeCiphers.toArray(new String[excludeCiphers.size()]);
                answer.setExcludeCipherSuites(arr);
            }
        }
        if (ssl != null && ssl.getSecureSocketProtocolsFilter() != null) {
            List includeProtocols = ssl.getSecureSocketProtocolsFilter().getInclude();
            if (includeProtocols != null && !includeProtocols.isEmpty()) {
                arr2 = includeProtocols.toArray(new String[includeProtocols.size()]);
                answer.setIncludeProtocols(arr2);
            } else {
                answer.setIncludeProtocols(new String[]{".*"});
            }
            List excludeProtocols = ssl.getSecureSocketProtocolsFilter().getExclude();
            if (excludeProtocols != null && !excludeProtocols.isEmpty()) {
                arr = excludeProtocols.toArray(new String[excludeProtocols.size()]);
                answer.setExcludeProtocols(arr);
            }
        }
        return answer;
    }

    protected boolean checkSSLContextFactoryConfig(Object instance) {
        try {
            Method method = instance.getClass().getMethod("checkConfig", new Class[0]);
            return (Boolean)method.invoke(instance, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    public Map<Integer, Connector> getSslSocketConnectors() {
        return this.sslSocketConnectors;
    }

    @Metadata(description="A map which contains per port number specific SSL connectors.", label="security")
    public void setSslSocketConnectors(Map<Integer, Connector> connectors) {
        this.sslSocketConnectors = connectors;
    }

    @Metadata(description="A map which contains per port number specific HTTP connectors. Uses the same principle as sslSocketConnectors.", label="security")
    public void setSocketConnectors(Map<Integer, Connector> socketConnectors) {
        this.socketConnectors = socketConnectors;
    }

    public CamelHttpClient createHttpClient(JettyHttpEndpoint endpoint, Integer minThreads, Integer maxThreads, SSLContextParameters ssl) throws Exception {
        int port;
        String host;
        SslContextFactory sslContextFactory = this.createSslContextFactory(ssl);
        HttpClientTransport transport = this.createHttpClientTransport(maxThreads);
        CamelHttpClient httpClient = this.createCamelHttpClient(transport, sslContextFactory);
        CamelContext context = endpoint.getCamelContext();
        if (context != null && ObjectHelper.isNotEmpty((Object)context.getProperty("http.proxyHost")) && ObjectHelper.isNotEmpty((Object)context.getProperty("http.proxyPort"))) {
            host = context.getProperty("http.proxyHost");
            port = Integer.parseInt(context.getProperty("http.proxyPort"));
            LOG.debug("CamelContext properties http.proxyHost and http.proxyPort detected. Using http proxy host: {} port: {}", (Object)host, (Object)port);
            httpClient.setProxy(host, port);
        }
        if (ObjectHelper.isNotEmpty((Object)endpoint.getProxyHost()) && endpoint.getProxyPort() > 0) {
            host = endpoint.getProxyHost();
            port = endpoint.getProxyPort();
            LOG.debug("proxyHost and proxyPort options detected. Using http proxy host: {} port: {}", (Object)host, (Object)port);
            httpClient.setProxy(host, port);
        }
        if (minThreads != null || maxThreads != null) {
            if (minThreads == null || maxThreads == null) {
                throw new IllegalArgumentException("Both min and max thread pool sizes must be provided.");
            }
            QueuedThreadPool qtp = new QueuedThreadPool();
            qtp.setMinThreads(minThreads.intValue());
            qtp.setMaxThreads(maxThreads.intValue());
            qtp.setDaemon(true);
            qtp.setName("CamelJettyClient(" + ObjectHelper.getIdentityHashCode((Object)((Object)httpClient)) + ")");
            httpClient.setThreadPoolOrExecutor((Executor)qtp);
        }
        if (LOG.isDebugEnabled()) {
            if (minThreads != null) {
                LOG.debug("Created HttpClient with thread pool {}-{} -> {}", new Object[]{minThreads, maxThreads, httpClient});
            } else {
                LOG.debug("Created HttpClient with default thread pool size -> {}", (Object)httpClient);
            }
        }
        return httpClient;
    }

    private HttpClientTransport createHttpClientTransport(Integer maxThreads) {
        if (maxThreads == null) {
            return new HttpClientTransportOverHTTP();
        }
        int selectors = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        if (selectors >= maxThreads) {
            selectors = maxThreads - 1;
        }
        return new HttpClientTransportOverHTTP(selectors);
    }

    protected abstract CamelHttpClient createCamelHttpClient(HttpClientTransport var1, SslContextFactory var2);

    public Integer getHttpClientMinThreads() {
        return this.httpClientMinThreads;
    }

    @Metadata(description="To set a value for minimum number of threads in HttpClient thread pool. Notice that both a min and max size must be configured.", label="producer")
    public void setHttpClientMinThreads(Integer httpClientMinThreads) {
        this.httpClientMinThreads = httpClientMinThreads;
    }

    public Integer getHttpClientMaxThreads() {
        return this.httpClientMaxThreads;
    }

    @Metadata(description="To set a value for maximum number of threads in HttpClient thread pool. Notice that both a min and max size must be configured.", label="producer")
    public void setHttpClientMaxThreads(Integer httpClientMaxThreads) {
        this.httpClientMaxThreads = httpClientMaxThreads;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    @Metadata(description="To set a value for minimum number of threads in server thread pool. Notice that both a min and max size must be configured.", label="consumer")
    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    @Metadata(description="To set a value for maximum number of threads in server thread pool. Notice that both a min and max size must be configured.", label="consumer")
    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    @Metadata(description="To use a custom thread pool for the server. This option should only be used in special circumstances.", label="consumer,advanced")
    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    @Metadata(description="If this option is true, Jetty JMX support will be enabled for this endpoint.")
    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public JettyHttpBinding getJettyHttpBinding() {
        return this.jettyHttpBinding;
    }

    @Metadata(description="To use a custom org.apache.camel.component.jetty.JettyHttpBinding, which are used to customize how a response should be written for the producer.", label="advanced")
    public void setJettyHttpBinding(JettyHttpBinding jettyHttpBinding) {
        this.jettyHttpBinding = jettyHttpBinding;
    }

    @Metadata(description="Not to be used - use JettyHttpBinding instead.", label="advanced")
    public void setHttpBinding(HttpBinding httpBinding) {
        throw new IllegalArgumentException("Not to be used - use JettyHttpBinding instead.");
    }

    @Metadata(description="Jetty component does not use HttpConfiguration.", label="advanced")
    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        throw new IllegalArgumentException("Jetty component does not use HttpConfiguration.");
    }

    public synchronized MBeanContainer getMbContainer() {
        if (this.mbContainer == null) {
            MBeanServer mbs = null;
            ManagementStrategy mStrategy = this.getCamelContext().getManagementStrategy();
            ManagementAgent mAgent = mStrategy.getManagementAgent();
            if (mAgent != null) {
                mbs = mAgent.getMBeanServer();
            }
            if (mbs != null) {
                this.mbContainer = new MBeanContainer(mbs);
                this.startMbContainer();
            } else {
                LOG.warn("JMX disabled in CamelContext. Jetty JMX extensions will remain disabled.");
            }
        }
        return this.mbContainer;
    }

    @Metadata(description="To use a existing configured org.eclipse.jetty.jmx.MBeanContainer if JMX is enabled that Jetty uses for registering mbeans.", label="advanced")
    public void setMbContainer(MBeanContainer mbContainer) {
        this.mbContainer = mbContainer;
    }

    public Map<String, Object> getSslSocketConnectorProperties() {
        return this.sslSocketConnectorProperties;
    }

    @Metadata(description="A map which contains general SSL connector properties.", label="security")
    public void setSslSocketConnectorProperties(Map<String, Object> sslSocketConnectorProperties) {
        this.sslSocketConnectorProperties = sslSocketConnectorProperties;
    }

    public Map<String, Object> getSocketConnectorProperties() {
        return this.socketConnectorProperties;
    }

    @Metadata(description="A map which contains general HTTP connector properties. Uses the same principle as sslSocketConnectorProperties.", label="security")
    public void setSocketConnectorProperties(Map<String, Object> socketConnectorProperties) {
        this.socketConnectorProperties = socketConnectorProperties;
    }

    public void addSocketConnectorProperty(String key, Object value) {
        if (this.socketConnectorProperties == null) {
            this.socketConnectorProperties = new HashMap<String, Object>();
        }
        this.socketConnectorProperties.put(key, value);
    }

    public void addSslSocketConnectorProperty(String key, Object value) {
        if (this.sslSocketConnectorProperties == null) {
            this.sslSocketConnectorProperties = new HashMap<String, Object>();
        }
        this.sslSocketConnectorProperties.put(key, value);
    }

    public Long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    @Metadata(description="Allows to set a timeout in millis when using Jetty as consumer (server). By default Jetty uses 30000. You can use a value of <= 0 to never expire. If a timeout occurs then the request will be expired and Jetty will return back a http error 503 to the client. This option is only in use when using Jetty with the Asynchronous Routing Engine.", defaultValue="30000", label="consumer")
    public void setContinuationTimeout(Long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public boolean isUseContinuation() {
        return this.useContinuation;
    }

    @Metadata(description="Whether or not to use Jetty continuations for the Jetty Server.", defaultValue="true", label="consumer")
    public void setUseContinuation(boolean useContinuation) {
        this.useContinuation = useContinuation;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    @Metadata(description="To configure security using SSLContextParameters", label="security")
    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    @Metadata(description="Enable usage of global SSL context parameters", label="security", defaultValue="false")
    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public Integer getResponseBufferSize() {
        return this.responseBufferSize;
    }

    @Metadata(description="Allows to configure a custom value of the response buffer size on the Jetty connectors.")
    public void setResponseBufferSize(Integer responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public Integer getRequestBufferSize() {
        return this.requestBufferSize;
    }

    @Metadata(description="Allows to configure a custom value of the request buffer size on the Jetty connectors.")
    public void setRequestBufferSize(Integer requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public Integer getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    @Metadata(description="Allows to configure a custom value of the request header size on the Jetty connectors.")
    public void setRequestHeaderSize(Integer requestHeaderSize) {
        this.requestHeaderSize = requestHeaderSize;
    }

    public Integer getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    @Metadata(description="Allows to configure a custom value of the response header size on the Jetty connectors.")
    public void setResponseHeaderSize(Integer responseHeaderSize) {
        this.responseHeaderSize = responseHeaderSize;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    @Metadata(description="To use a http proxy to configure the hostname.", label="proxy")
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Metadata(description="To use a http proxy to configure the port number.", label="proxy")
    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isUseXForwardedForHeader() {
        return this.useXForwardedForHeader;
    }

    @Metadata(description="To use the X-Forwarded-For header in HttpServletRequest.getRemoteAddr.")
    public void setUseXForwardedForHeader(boolean useXForwardedForHeader) {
        this.useXForwardedForHeader = useXForwardedForHeader;
    }

    public boolean isSendServerVersion() {
        return this.sendServerVersion;
    }

    @Metadata(description="If the option is true, jetty will send the server header with the jetty version information to the client which sends the request. NOTE please make sure there is no any other camel-jetty endpoint is share the same port, otherwise this option may not work as expected.", defaultValue="true", label="consumer")
    public void setSendServerVersion(boolean sendServerVersion) {
        this.sendServerVersion = sendServerVersion;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        boolean cors;
        String contextPath;
        int num;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = configuration;
        if (config == null) {
            config = camelContext.getRestConfiguration("jetty", true);
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        if (ObjectHelper.isEmpty((Object)host)) {
            if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if ((config.getComponent() == null || config.getComponent().equals("jetty")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        if (cors = config.isEnableCORS()) {
            map.put("optionsEnabled", "true");
        }
        String query = URISupport.createQueryString(map);
        String url = api ? "jetty:%s://%s:%s/%s?matchOnUriPrefix=true&httpMethodRestrict=%s" : "jetty:%s://%s:%s/%s?httpMethodRestrict=%s";
        String restrict = verb.toUpperCase(Locale.US);
        if (cors) {
            restrict = restrict + ",OPTIONS";
        }
        url = String.format(url, scheme, host, port, path, restrict);
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)camelContext.getEndpoint(url, JettyHttpEndpoint.class);
        this.setProperties(camelContext, (Object)endpoint, parameters);
        if (!map.containsKey("httpBindingRef")) {
            endpoint.setHttpBinding((HttpBinding)new JettyRestHttpBinding(endpoint));
            endpoint.setEnableMultipartFilter(false);
        }
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        ServiceHelper.startService((Service)endpoint);
        return consumer;
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String query;
        RestConfiguration config;
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        String url = "jetty:" + host;
        if (!ObjectHelper.isEmpty((Object)basePath)) {
            url = url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((Object)uriTemplate)) {
            url = url + "/" + uriTemplate;
        }
        if ((config = configuration) == null) {
            config = camelContext.getRestConfiguration("jetty", true);
        }
        HashMap map = new HashMap();
        if ((config.getComponent() == null || config.getComponent().equals("jetty")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        if (!(query = URISupport.createQueryString(map)).isEmpty()) {
            url = url + "?" + query;
        }
        RestProducerFactoryHelper.setupComponentFor((String)url, (CamelContext)camelContext, (Map)((Map)parameters.get("component")));
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)camelContext.getEndpoint(url, JettyHttpEndpoint.class);
        if (parameters != null && !parameters.isEmpty()) {
            this.setProperties(camelContext, (Object)endpoint, parameters);
        }
        String path = uriTemplate != null ? uriTemplate : basePath;
        endpoint.setHeaderFilterStrategy((HeaderFilterStrategy)new HttpRestHeaderFilterStrategy(path, queryParameters));
        return endpoint.createProducer();
    }

    protected CamelServlet createServletForConnector(Server server, Connector connector, List<Handler> handlers, JettyHttpEndpoint endpoint) throws Exception {
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 0);
        if (Server.getVersion().startsWith("8")) {
            context.getClass().getMethod("setConnectorNames", String[].class).invoke((Object)context, new Object[]{new String[]{connector.getName()}});
        }
        this.addJettyHandlers(server, handlers);
        CamelContinuationServlet camelServlet = new CamelContinuationServlet();
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)camelServlet);
        holder.setAsyncSupported(true);
        holder.setInitParameter("async", Boolean.toString(endpoint.isAsync()));
        context.addServlet(holder, "/*");
        camelServlet.setServletResolveConsumerStrategy((ServletResolveConsumerStrategy)new HttpRestServletResolveConsumerStrategy());
        return camelServlet;
    }

    protected void addJettyHandlers(Server server, List<Handler> handlers) {
        if (handlers != null && !handlers.isEmpty()) {
            for (Handler handler : handlers) {
                if (handler instanceof HandlerWrapper) {
                    if (this.isHandlerInChain(server.getHandler(), handler)) continue;
                    ((HandlerWrapper)handler).setHandler(server.getHandler());
                    server.setHandler(handler);
                    continue;
                }
                HandlerCollection handlerCollection = new HandlerCollection();
                handlerCollection.addHandler(server.getHandler());
                handlerCollection.addHandler(handler);
                server.setHandler((Handler)handlerCollection);
            }
        }
    }

    protected boolean isHandlerInChain(Handler current, Handler handler) {
        if (handler.equals(current)) {
            return true;
        }
        if (current instanceof HandlerWrapper) {
            return this.isHandlerInChain(((HandlerWrapper)current).getHandler(), handler);
        }
        return false;
    }

    protected Server createServer() {
        Server s = null;
        ThreadPool tp = this.threadPool;
        QueuedThreadPool qtp = null;
        if (this.minThreads != null || this.maxThreads != null) {
            if (this.getThreadPool() != null) {
                throw new IllegalArgumentException("You cannot configure both minThreads/maxThreads and a custom threadPool on JettyHttpComponent: " + (Object)((Object)this));
            }
            qtp = new QueuedThreadPool();
            if (this.minThreads != null) {
                qtp.setMinThreads(this.minThreads.intValue());
            }
            if (this.maxThreads != null) {
                qtp.setMaxThreads(this.maxThreads.intValue());
            }
            tp = qtp;
        }
        if (tp != null) {
            try {
                if (!Server.getVersion().startsWith("8")) {
                    s = (Server)Server.class.getConstructor(ThreadPool.class).newInstance(tp);
                } else {
                    s = new Server();
                    if (this.isEnableJmx()) {
                        this.enableJmx(s);
                    }
                    Server.class.getMethod("setThreadPool", ThreadPool.class).invoke((Object)s, tp);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new Server();
        }
        if (qtp != null) {
            qtp.setName("CamelJettyServer(" + ObjectHelper.getIdentityHashCode((Object)s) + ")");
            try {
                qtp.start();
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error starting JettyServer thread pool: " + qtp, (Throwable)e);
            }
        }
        ContextHandlerCollection collection = new ContextHandlerCollection();
        s.setHandler((Handler)collection);
        if (this.getErrorHandler() != null) {
            s.addBean((Object)this.getErrorHandler());
        } else if (!Server.getVersion().startsWith("8")) {
            ErrorHandler eh = new ErrorHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                    String msg = HttpStatus.getMessage((int)response.getStatus());
                    request.setAttribute("javax.servlet.error.message", (Object)msg);
                    if (response instanceof Response) {
                        ((Response)response).setStatus(response.getStatus(), msg);
                    }
                    super.handle(target, baseRequest, request, response);
                }

                protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
                    super.writeErrorPage(request, writer, code, message, false);
                }
            };
            s.addBean((Object)eh, false);
        }
        return s;
    }

    protected void startMbContainer() {
        if (this.mbContainer != null && Server.getVersion().startsWith("8")) {
            try {
                boolean b = (Boolean)this.mbContainer.getClass().getMethod("isStarted", new Class[0]).invoke((Object)this.mbContainer, new Object[0]);
                if (b) {
                    this.mbContainer.getClass().getMethod("start", new Class[0]).invoke((Object)this.mbContainer, new Object[0]);
                    this.mbContainer.getClass().getMethod("addBean", Object.class).invoke((Object)this.mbContainer, this.mbContainer);
                }
            }
            catch (Throwable e) {
                LOG.warn("Could not start Jetty MBeanContainer. Jetty JMX extensions will remain disabled.", e);
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        RestConfiguration config = this.getCamelContext().getRestConfiguration("jetty", true);
        if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
            this.setProperties((Object)this, config.getComponentProperties());
        }
        this.startMbContainer();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (CONNECTORS.size() > 0) {
            for (String connectorKey : CONNECTORS.keySet()) {
                ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
                if (connectorRef == null || connectorRef.getRefCount() != 0) continue;
                connectorRef.server.removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                this.removeServerMBean(connectorRef.server);
                connectorRef.server.stop();
                CONNECTORS.remove(connectorKey);
            }
        }
        if (this.mbContainer != null) {
            try {
                this.mbContainer.getClass().getMethod("stop", new Class[0]).invoke((Object)this.mbContainer, new Object[0]);
            }
            catch (Throwable t) {
                this.mbContainer.getClass().getMethod("destroy", new Class[0]).invoke((Object)this.mbContainer, new Object[0]);
            }
            this.mbContainer = null;
        }
    }

    private void addServerMBean(Server server) {
        if (this.mbContainer == null) {
            return;
        }
        try {
            Container o = JettyHttpComponent.getContainer(server);
            o.getClass().getMethod("addEventListener", Container.Listener.class).invoke((Object)o, this.mbContainer);
            if (Server.getVersion().startsWith("8")) {
                return;
            }
            this.mbContainer.getClass().getMethod("beanAdded", Container.class, Object.class).invoke((Object)this.mbContainer, null, server);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception r) {
            throw new RuntimeException(r);
        }
    }

    private void removeServerMBean(Server server) {
        try {
            this.mbContainer.getClass().getMethod("beanRemoved", Container.class, Object.class).invoke((Object)this.mbContainer, null, server);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception r) {
            try {
                this.mbContainer.getClass().getMethod("removeBean", Object.class).invoke((Object)this.mbContainer, server);
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception r2) {
                throw new RuntimeException(r);
            }
        }
    }

    private static Container getContainer(Object server) {
        if (server instanceof Container) {
            return (Container)server;
        }
        try {
            return (Container)server.getClass().getMethod("getContainer", new Class[0]).invoke(server, new Object[0]);
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    class ConnectorRef {
        CamelContext camelContext;
        Server server;
        Connector connector;
        CamelServlet servlet;
        int refCount;

        ConnectorRef(CamelContext camelContext, Server server, Connector connector, CamelServlet servlet) {
            this.camelContext = camelContext;
            this.server = server;
            this.connector = connector;
            this.servlet = servlet;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }

        public int getRefCount() {
            return this.refCount;
        }
    }
}

