/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class CamelContinuationServlet
extends CamelServlet {
    static final String EXCHANGE_ATTRIBUTE_NAME = "CamelExchange";
    static final String EXCHANGE_ATTRIBUTE_ID = "CamelExchangeId";
    private static final long serialVersionUID = 1L;
    private final Map<String, String> expiredExchanges = new ConcurrentHashMap<String, String>();

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.trace("Service: {}", (Object)request);
        final HttpConsumer consumer = this.getServletResolveConsumerStrategy().resolve(request, this.getConsumers());
        if (consumer == null) {
            boolean hasAnyMethod = METHODS.stream().anyMatch(m -> this.getServletResolveConsumerStrategy().isHttpMethodAllowed(request, m, this.getConsumers()));
            if (hasAnyMethod) {
                this.log.debug("No consumer to service request {} as method {} is not allowed", (Object)request, (Object)request.getMethod());
                response.sendError(405);
                return;
            }
            this.log.debug("No consumer to service request {} as resource is not found", (Object)request);
            response.sendError(404);
            return;
        }
        boolean useContinuation = false;
        Object continuationTimeout = null;
        HttpCommonEndpoint endpoint = consumer.getEndpoint();
        if (endpoint instanceof JettyHttpEndpoint) {
            JettyHttpEndpoint jettyEndpoint = (JettyHttpEndpoint)endpoint;
            Boolean epUseContinuation = jettyEndpoint.getUseContinuation();
            Long epContinuationTimeout = jettyEndpoint.getContinuationTimeout();
            useContinuation = epUseContinuation != null ? epUseContinuation.booleanValue() : jettyEndpoint.getComponent().isUseContinuation();
            continuationTimeout = epContinuationTimeout != null ? epContinuationTimeout : jettyEndpoint.getComponent().getContinuationTimeout();
        }
        if (!useContinuation) {
            this.log.trace("Usage of continuation is disabled, either by component or endpoint configuration, fallback to normal servlet processing instead");
            super.doService(request, response);
            return;
        }
        this.log.trace("Start request with continuation timeout of {}", continuationTimeout != null ? continuationTimeout : "jetty default");
        if ("OPTIONS".equals(request.getMethod()) && !consumer.isOptionsEnabled()) {
            String allowedMethods = METHODS.stream().filter(m -> this.getServletResolveConsumerStrategy().isHttpMethodAllowed(request, m, this.getConsumers())).collect(Collectors.joining(","));
            if (allowedMethods == null && consumer.getEndpoint().getHttpMethodRestrict() != null) {
                allowedMethods = consumer.getEndpoint().getHttpMethodRestrict();
            }
            if (allowedMethods == null) {
                allowedMethods = "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
            }
            if (!allowedMethods.contains("OPTIONS")) {
                allowedMethods = allowedMethods + ",OPTIONS";
            }
            response.addHeader("Allow", allowedMethods);
            response.setStatus(200);
            return;
        }
        if (consumer.getEndpoint().getHttpMethodRestrict() != null) {
            Iterator it = ObjectHelper.createIterable((String)consumer.getEndpoint().getHttpMethodRestrict()).iterator();
            boolean match = false;
            while (it.hasNext()) {
                String method = it.next().toString();
                if (!method.equalsIgnoreCase(request.getMethod())) continue;
                match = true;
                break;
            }
            if (!match) {
                response.sendError(405);
                return;
            }
        }
        if ("TRACE".equals(request.getMethod()) && !consumer.isTraceEnabled()) {
            response.sendError(405);
            return;
        }
        String contentType = request.getContentType();
        if ("application/x-java-serialized-object".equals(contentType) && !consumer.getEndpoint().getComponent().isAllowJavaSerializedObject()) {
            response.sendError(415);
            return;
        }
        Exchange result = (Exchange)request.getAttribute(EXCHANGE_ATTRIBUTE_NAME);
        if (result == null) {
            final Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            if (continuation.isInitial() && continuationTimeout != null) {
                continuation.setTimeout(((Long)continuationTimeout).longValue());
            }
            if (consumer.isSuspended() && continuation.isInitial()) {
                response.sendError(503);
                return;
            }
            if (continuation.isExpired()) {
                String id = (String)continuation.getAttribute(EXCHANGE_ATTRIBUTE_ID);
                this.expiredExchanges.put(id, id);
                this.log.warn("Continuation expired of exchangeId: {}", (Object)id);
                consumer.getBinding().doWriteExceptionResponse((Throwable)new TimeoutException(), response);
                return;
            }
            final Exchange exchange = consumer.createExchange(false);
            exchange.setPattern(ExchangePattern.InOut);
            if (consumer.getEndpoint().isBridgeEndpoint()) {
                exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
                exchange.setProperty("CamelSkipWwwFormUrlEncoding", (Object)Boolean.TRUE);
            }
            if (consumer.getEndpoint().isDisableStreamCache()) {
                exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
            }
            HttpHelper.setCharsetFromContentType((String)request.getContentType(), (Exchange)exchange);
            Message msg = exchange.getIn();
            if (msg instanceof HttpMessage) {
                HttpMessage hm = (HttpMessage)msg;
                hm.init(exchange, endpoint, request, response);
            } else {
                exchange.setIn((Message)new HttpMessage(exchange, endpoint, request, response));
            }
            String contextPath = consumer.getEndpoint().getPath();
            exchange.getIn().setHeader("CamelServletContextPath", (Object)contextPath);
            this.updateHttpPath(exchange, contextPath);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Suspending continuation of exchangeId: {}", (Object)exchange.getExchangeId());
            }
            continuation.setAttribute(EXCHANGE_ATTRIBUTE_ID, (Object)exchange.getExchangeId());
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow == null) {
                try {
                    consumer.createUoW(exchange);
                }
                catch (Exception e) {
                    this.log.error("Error processing request", (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
            } else if (uow.onPrepare(exchange)) {
                ExtendedExchange ee = (ExtendedExchange)exchange;
                ee.setUnitOfWork(uow);
            }
            continuation.suspend();
            ClassLoader oldTccl = this.overrideTccl(exchange);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Processing request for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            consumer.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    boolean expired;
                    boolean bl = expired = CamelContinuationServlet.this.expiredExchanges.remove(exchange.getExchangeId()) != null;
                    if (!expired) {
                        if (CamelContinuationServlet.this.log.isTraceEnabled()) {
                            CamelContinuationServlet.this.log.trace("Resuming continuation of exchangeId: {}", (Object)exchange.getExchangeId());
                        }
                        continuation.setAttribute(CamelContinuationServlet.EXCHANGE_ATTRIBUTE_NAME, (Object)exchange);
                        continuation.resume();
                    } else {
                        CamelContinuationServlet.this.log.warn("Cannot resume expired continuation of exchangeId: {}", (Object)exchange.getExchangeId());
                        consumer.releaseExchange(exchange, false);
                    }
                }
            });
            if (oldTccl != null) {
                this.restoreTccl(exchange, oldTccl);
            }
            return;
        }
        try {
            Integer bs;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Resumed continuation and writing response for exchangeId: {}", (Object)result.getExchangeId());
            }
            if ((bs = consumer.getEndpoint().getResponseBufferSize()) != null) {
                this.log.trace("Using response buffer size: {}", (Object)bs);
                response.setBufferSize(bs.intValue());
            }
            consumer.getBinding().writeResponse(result, response);
        }
        catch (IOException e) {
            this.log.error("Error processing request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Error processing request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            consumer.doneUoW(result);
            consumer.releaseExchange(result, false);
        }
    }

    private void updateHttpPath(Exchange exchange, String contextPath) {
        String httpPath = (String)exchange.getIn().getHeader("CamelHttpPath");
        String encodedContextPath = UnsafeUriCharactersEncoder.encodeHttpURI((String)contextPath);
        if (contextPath != null && httpPath.startsWith(encodedContextPath)) {
            exchange.getIn().setHeader("CamelHttpPath", (Object)httpPath.substring(encodedContextPath.length()));
        }
    }

    public void destroy() {
        this.expiredExchanges.clear();
        super.destroy();
    }
}

