/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelFilterWrapper
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CamelFilterWrapper.class);
    private Filter wrapped;

    public CamelFilterWrapper(Filter wrapped) {
        this.wrapped = wrapped;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute("CamelExchange") == null) {
            this.wrapped.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.wrapped.destroy();
    }

    public void init(FilterConfig config) throws ServletException {
        Object o = config.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
        if (o == null) {
            try {
                File file = Files.createTempFile("camel", "", new FileAttribute[0]).toFile();
                boolean result = file.delete();
                if (!result) {
                    LOG.error("failed to delete {}", (Object)file);
                }
                config.getServletContext().setAttribute("jakarta.servlet.context.tempdir", (Object)file.getParentFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.wrapped.init(config);
    }
}

