/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHttpComponent
extends HttpComponent {
    protected static final HashMap<String, ConnectorRef> CONNECTORS = new HashMap();
    private static final transient Log LOG = LogFactory.getLog(JettyHttpComponent.class);
    private static final String JETTY_SSL_KEYSTORE = "jetty.ssl.keystore";
    protected String sslKeyPassword;
    protected String sslPassword;
    protected String sslKeystore;
    protected Map<Integer, SslSocketConnector> sslSocketConnectors;
    protected HttpClient httpClient;
    protected ThreadPool httpClientThreadPool;
    protected Integer httpClientMinThreads;
    protected Integer httpClientMaxThreads;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        uri = uri.startsWith("jetty:") ? remaining : uri;
        List handlerList = this.resolveAndRemoveReferenceListParameter(parameters, "handlers", Handler.class);
        this.configureParameters(parameters);
        JettyHttpEndpoint result = new JettyHttpEndpoint(this, uri, null);
        if (this.httpBinding != null) {
            result.setBinding(this.httpBinding);
        }
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        if (handlerList.size() > 0) {
            result.setHandlers(handlerList);
        }
        this.setProperties((Object)result, parameters);
        if (IntrospectionSupport.hasProperties(parameters, (String)"httpClient.")) {
            result.setClient(this.getHttpClient());
            IntrospectionSupport.setProperties((Object)this.getHttpClient(), parameters, (String)"httpClient.");
            this.validateParameters(uri, parameters, "httpClient.");
        }
        URI httpUri = URISupport.createRemainingURI((URI)new URI(UnsafeUriCharactersEncoder.encode((String)uri)), (Map)CastUtils.cast(parameters));
        result.setHttpUri(httpUri);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(HttpConsumer consumer) throws Exception {
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef == null) {
                Object connector = "https".equals(endpoint.getProtocol()) ? this.getSslSocketConnector(endpoint.getPort()) : new SelectChannelConnector();
                connector.setPort(endpoint.getPort());
                connector.setHost(endpoint.getHttpUri().getHost());
                if ("localhost".equalsIgnoreCase(endpoint.getHttpUri().getHost())) {
                    LOG.warn((Object)"You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)?");
                }
                Server server = this.createServer();
                server.addConnector((Connector)connector);
                connectorRef = new ConnectorRef(server, (Connector)connector, this.createServletForConnector(server, (Connector)connector, endpoint.getHandlers()));
                connector.start();
                CONNECTORS.put(connectorKey, connectorRef);
            } else {
                connectorRef.increment();
            }
            if (endpoint.isSessionSupport()) {
                this.enableSessionSupport(connectorRef.server);
            }
            connectorRef.servlet.connect(consumer);
        }
    }

    private void enableSessionSupport(Server server) throws Exception {
        Context context = (Context)server.getChildHandlerByClass(Context.class);
        if (context.getSessionHandler() == null) {
            SessionHandler sessionHandler = new SessionHandler();
            context.setSessionHandler(sessionHandler);
            if (context.isStarted()) {
                context.stop();
                context.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(HttpConsumer consumer) throws Exception {
        HttpEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef != null) {
                connectorRef.servlet.disconnect(consumer);
                if (connectorRef.decrement() == 0) {
                    connectorRef.server.removeConnector(connectorRef.connector);
                    connectorRef.connector.stop();
                    connectorRef.server.stop();
                    CONNECTORS.remove(connectorKey);
                }
            }
        }
    }

    private String getConnectorKey(HttpEndpoint endpoint) {
        return endpoint.getProtocol() + ":" + endpoint.getHttpUri().getHost() + ":" + endpoint.getPort();
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getKeystore() {
        return this.sslKeystore;
    }

    public SslSocketConnector getSslSocketConnector(int port) {
        SslSocketConnector answer = null;
        if (this.sslSocketConnectors != null) {
            answer = this.sslSocketConnectors.get(port);
        }
        if (answer == null) {
            answer = this.createSslSocketConnector();
        } else {
            String keystoreProperty = System.getProperty(JETTY_SSL_KEYSTORE);
            if (keystoreProperty != null) {
                answer.setKeystore(keystoreProperty);
            }
        }
        return answer;
    }

    public SslSocketConnector createSslSocketConnector() {
        SslSocketConnector answer = new SslSocketConnector();
        answer.setPassword(this.sslPassword);
        answer.setKeyPassword(this.sslKeyPassword);
        if (this.sslKeystore != null) {
            answer.setKeystore(this.sslKeystore);
        } else {
            String keystoreProperty = System.getProperty(JETTY_SSL_KEYSTORE);
            if (keystoreProperty != null) {
                answer.setKeystore(keystoreProperty);
            }
        }
        return answer;
    }

    public void setSslSocketConnectors(Map<Integer, SslSocketConnector> connectors) {
        this.sslSocketConnectors = connectors;
    }

    public synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
            this.httpClient.setConnectorType(2);
            if (System.getProperty("http.proxyHost") != null && System.getProperty("http.proxyPort") != null) {
                String host = System.getProperty("http.proxyHost");
                int port = Integer.parseInt(System.getProperty("http.proxyPort"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Java System Property http.proxyHost and http.proxyPort detected. Using http proxy host: " + host + " port: " + port));
                }
                this.httpClient.setProxy(new Address(host, port));
            }
            if (this.getHttpClientThreadPool() == null) {
                QueuedThreadPool qtp = new QueuedThreadPool();
                if (this.httpClientMinThreads != null) {
                    qtp.setMinThreads(this.httpClientMinThreads.intValue());
                }
                if (this.httpClientMaxThreads != null) {
                    qtp.setMaxThreads(this.httpClientMaxThreads.intValue());
                }
                try {
                    qtp.start();
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error starting JettyHttpClient thread pool: " + qtp, (Throwable)e);
                }
                this.setHttpClientThreadPool((ThreadPool)qtp);
            }
            this.httpClient.setThreadPool(this.getHttpClientThreadPool());
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ThreadPool getHttpClientThreadPool() {
        return this.httpClientThreadPool;
    }

    public void setHttpClientThreadPool(ThreadPool httpClientThreadPool) {
        this.httpClientThreadPool = httpClientThreadPool;
    }

    public Integer getHttpClientMinThreads() {
        return this.httpClientMinThreads;
    }

    public void setHttpClientMinThreads(Integer httpClientMinThreads) {
        this.httpClientMinThreads = httpClientMinThreads;
    }

    public Integer getHttpClientMaxThreads() {
        return this.httpClientMaxThreads;
    }

    public void setHttpClientMaxThreads(Integer httpClientMaxThreads) {
        this.httpClientMaxThreads = httpClientMaxThreads;
    }

    protected CamelServlet createServletForConnector(Server server, Connector connector, List<Handler> handlers) throws Exception {
        CamelServlet camelServlet = new CamelServlet();
        Context context = new Context((HandlerContainer)server, "/", 0);
        context.setConnectorNames(new String[]{connector.getName()});
        if (handlers != null) {
            for (Handler handler : handlers) {
                context.addHandler(handler);
            }
        }
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)camelServlet);
        context.addServlet(holder, "/*");
        connector.start();
        context.start();
        return camelServlet;
    }

    protected Server createServer() throws Exception {
        Server server = new Server();
        ContextHandlerCollection collection = new ContextHandlerCollection();
        collection.setServer(server);
        server.addHandler((Handler)collection);
        server.start();
        return server;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.httpClientThreadPool != null && this.httpClientThreadPool instanceof LifeCycle) {
            LifeCycle lc = (LifeCycle)this.httpClientThreadPool;
            lc.start();
        }
        if (this.httpClient != null && !this.httpClient.isStarted()) {
            this.httpClient.start();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
        if (this.httpClientThreadPool != null && this.httpClientThreadPool instanceof LifeCycle) {
            LifeCycle lc = (LifeCycle)this.httpClientThreadPool;
            lc.stop();
        }
    }

    class ConnectorRef {
        Server server;
        Connector connector;
        CamelServlet servlet;
        int refCount;

        public ConnectorRef(Server server, Connector connector, CamelServlet servlet) {
            this.server = server;
            this.connector = connector;
            this.servlet = servlet;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }
    }
}

