/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Message;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.helper.HttpProducerHelper;
import org.apache.camel.component.jetty.JettyContentExchange;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;

public class JettyHttpProducer
extends DefaultProducer
implements AsyncProcessor {
    private static final transient Log LOG = LogFactory.getLog(JettyHttpProducer.class);
    private final HttpClient client;
    private JettyHttpBinding binding;

    public JettyHttpProducer(Endpoint endpoint, HttpClient client) {
        super(endpoint);
        this.client = client;
    }

    public JettyHttpEndpoint getEndpoint() {
        return (JettyHttpEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        HttpClient client = this.getEndpoint().getClient();
        JettyContentExchange httpExchange = this.createHttpExchange(exchange);
        this.sendSynchronous(exchange, client, httpExchange);
    }

    public void process(Exchange exchange, AsyncCallback callback) throws Exception {
        HttpClient client = this.getEndpoint().getClient();
        JettyContentExchange httpExchange = this.createHttpExchange(exchange);
        this.sendAsynchronous(exchange, client, httpExchange, callback);
    }

    protected void sendAsynchronous(Exchange exchange, HttpClient client, JettyContentExchange httpExchange, AsyncCallback callback) throws IOException {
        httpExchange.setCallback(callback);
        JettyHttpProducer.doSendExchange(client, httpExchange);
    }

    protected void sendSynchronous(Exchange exchange, HttpClient client, JettyContentExchange httpExchange) throws Exception {
        JettyHttpProducer.doSendExchange(client, httpExchange);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Waiting for HTTP exchange to be done");
        }
        int exchangeState = httpExchange.waitForDoneOrFailure();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("HTTP exchange is done with state " + exchangeState));
        }
        if (exchangeState == 7) {
            this.getBinding().populateResponse(exchange, httpExchange);
        } else {
            if (exchangeState == 8) {
                throw new ExchangeTimedOutException(exchange, client.getTimeout());
            }
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
            exchange.setException((Exception)new CamelExchangeException("JettyClient failed with state " + exchangeState, exchange));
        }
    }

    protected JettyContentExchange createHttpExchange(Exchange exchange) throws Exception {
        String url = HttpProducerHelper.createURL((Exchange)exchange, (HttpEndpoint)this.getEndpoint());
        HttpMethods methodToUse = HttpProducerHelper.createMethod((Exchange)exchange, (HttpEndpoint)this.getEndpoint(), (exchange.getIn().getBody() != null ? 1 : 0) != 0);
        String method = methodToUse.createMethod(url).getName();
        JettyContentExchange httpExchange = new JettyContentExchange(exchange, this.getBinding(), this.client);
        httpExchange.setMethod(method);
        httpExchange.setURL(url);
        this.doSetQueryParameters(exchange, httpExchange);
        if (HttpMethods.POST.equals((Object)methodToUse)) {
            String data;
            String contentType = ExchangeHelper.getContentType((Exchange)exchange);
            if (contentType != null) {
                httpExchange.setRequestContentType(contentType);
            }
            if ((data = (String)exchange.getIn().getBody(String.class)) != null) {
                String charset = (String)exchange.getProperty("CamelCharsetName", String.class);
                if (charset != null) {
                    httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(data, charset));
                } else {
                    httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(data));
                }
            } else {
                InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, exchange.getIn().getBody());
                httpExchange.setRequestContentSource(is);
            }
        }
        Message in = exchange.getIn();
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        for (String headerName : in.getHeaders().keySet()) {
            String headerValue = (String)in.getHeader(headerName, String.class);
            if (strategy == null || strategy.applyFilterToCamelHeaders(headerName, (Object)headerValue, exchange)) continue;
            httpExchange.addRequestHeader(headerName, headerValue);
        }
        return httpExchange;
    }

    private void doSetQueryParameters(Exchange exchange, JettyContentExchange httpExchange) throws URISyntaxException {
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = this.getEndpoint().getHttpUri().getQuery();
        }
        if (ObjectHelper.isEmpty((Object)queryString)) {
            return;
        }
        String uri = httpExchange.getURI();
        Map parameters = URISupport.parseParameters((URI)new URI(uri));
        parameters.putAll(URISupport.parseQuery((String)queryString));
        if (uri.contains("?")) {
            uri = ObjectHelper.before((String)uri, (String)"?");
        }
        if (!parameters.isEmpty()) {
            uri = uri + "?" + URISupport.createQueryString((Map)parameters);
            httpExchange.setURI(uri);
        }
    }

    protected static void doSendExchange(HttpClient client, JettyContentExchange httpExchange) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending HTTP request to: " + httpExchange.getUrl()));
        }
        client.send((HttpExchange)httpExchange);
    }

    public JettyHttpBinding getBinding() {
        return this.binding;
    }

    public void setBinding(JettyHttpBinding binding) {
        this.binding = binding;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.client.start();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.client.stop();
    }
}

