/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.impl.DefaultExchange;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class CamelContinuationServlet
extends CamelServlet {
    static final String EXCHANGE_ATTRIBUTE_NAME = "CamelExchange";
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HttpConsumer consumer = this.resolve(request);
            if (consumer == null) {
                response.sendError(404);
                return;
            }
            Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            if (consumer.isSuspended() && continuation.isInitial()) {
                response.sendError(503);
                return;
            }
            if (continuation.isInitial()) {
                DefaultExchange exchange = new DefaultExchange((Endpoint)consumer.getEndpoint(), ExchangePattern.InOut);
                if (consumer.getEndpoint().isBridgeEndpoint()) {
                    exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
                }
                if (consumer.getEndpoint().isDisableStreamCache()) {
                    exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
                }
                exchange.setIn((Message)new HttpMessage((Exchange)exchange, request, response));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Suspending continuation of exchangeId: " + exchange.getExchangeId()));
                }
                continuation.suspend();
                consumer.getAsyncProcessor().process((Exchange)exchange, new AsyncCallback((Exchange)exchange, continuation){
                    final /* synthetic */ Exchange val$exchange;
                    final /* synthetic */ Continuation val$continuation;
                    {
                        this.val$exchange = exchange;
                        this.val$continuation = continuation;
                    }

                    public void done(boolean doneSync) {
                        if (CamelContinuationServlet.this.log.isTraceEnabled()) {
                            CamelContinuationServlet.this.log.trace((Object)("Resuming continuation of exchangeId: " + this.val$exchange.getExchangeId()));
                        }
                        this.val$continuation.setAttribute(CamelContinuationServlet.EXCHANGE_ATTRIBUTE_NAME, (Object)this.val$exchange);
                        this.val$continuation.resume();
                    }
                });
                return;
            }
            if (continuation.isResumed()) {
                Exchange exchange = (Exchange)continuation.getAttribute(EXCHANGE_ATTRIBUTE_NAME);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Resuming continuation of exchangeId: " + exchange.getExchangeId()));
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Writing response of exchangeId: " + exchange.getExchangeId()));
                }
                consumer.getBinding().writeResponse(exchange, response);
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Error processing request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Error processing request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }
}

