/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.util.IOHelper;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.io.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyContentExchange
extends ContentExchange {
    private static final transient Logger LOG = LoggerFactory.getLogger(JettyContentExchange.class);
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private volatile Exchange exchange;
    private volatile AsyncCallback callback;
    private volatile JettyHttpBinding jettyBinding;
    private volatile HttpClient client;
    private final CountDownLatch done = new CountDownLatch(1);

    public JettyContentExchange(Exchange exchange, JettyHttpBinding jettyBinding, HttpClient client) {
        super(true);
        this.exchange = exchange;
        this.jettyBinding = jettyBinding;
        this.client = client;
    }

    public void setCallback(AsyncCallback callback) {
        this.callback = callback;
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        super.onResponseHeader(name, value);
        this.headers.put(name.toString(), value.toString());
    }

    protected void onRequestComplete() throws IOException {
        InputStream is = this.getRequestContentSource();
        if (is != null) {
            IOHelper.close((Closeable)is, (String)"RequestContentSource", (Logger)LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onResponseComplete() throws IOException {
        try {
            super.onResponseComplete();
        }
        finally {
            this.doTaskCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExpire() {
        try {
            super.onExpire();
        }
        finally {
            this.doTaskCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onException(Throwable ex) {
        try {
            super.onException(ex);
        }
        finally {
            this.doTaskCompleted(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectionFailed(Throwable ex) {
        try {
            super.onConnectionFailed(ex);
        }
        finally {
            this.doTaskCompleted(ex);
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() throws UnsupportedEncodingException {
        return super.getResponseContent();
    }

    public String getUrl() {
        String params = this.getRequestFields().getStringField("Content-Encoding");
        return this.getScheme() + "//" + this.getAddress().toString() + this.getURI() + (params != null ? "?" + params : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTaskCompleted() {
        this.done.countDown();
        if (this.callback == null) {
            return;
        }
        int exchangeState = this.getStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug("TaskComplete with state {} for url: {}", (Object)exchangeState, (Object)this.getUrl());
        }
        try {
            if (exchangeState == 7) {
                try {
                    this.jettyBinding.populateResponse(this.exchange, this);
                }
                catch (Exception e) {
                    this.exchange.setException((Throwable)e);
                }
            } else if (exchangeState == 8) {
                this.exchange.setException((Throwable)new ExchangeTimedOutException(this.exchange, this.client.getTimeout()));
            } else if (this.exchange.getException() != null) {
                this.exchange.setException((Throwable)new CamelExchangeException("JettyClient failed with state " + exchangeState, this.exchange));
            }
        }
        finally {
            this.callback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTaskCompleted(Throwable ex) {
        try {
            this.exchange.setException((Throwable)new CamelExchangeException("JettyClient failed cause by: " + ex.getMessage(), this.exchange, ex));
        }
        finally {
            this.done.countDown();
        }
        if (this.callback != null) {
            this.callback.done(false);
        }
    }
}

