/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty12;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.DefaultAttachment;
import org.apache.camel.attachment.DefaultAttachmentMessage;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AttachmentHttpBinding
extends DefaultHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentHttpBinding.class);

    AttachmentHttpBinding() {
    }

    protected void populateAttachments(HttpServletRequest request, Message message) {
        Boolean object = (Boolean)request.getAttribute("populate.multipart");
        if (object != null && object.booleanValue()) {
            try {
                Collection parts = request.getParts();
                for (Part part : parts) {
                    PartDataSource ds = new PartDataSource(part);
                    DefaultAttachment attachment = new DefaultAttachment((DataSource)ds);
                    for (String headerName : part.getHeaderNames()) {
                        for (String headerValue : part.getHeaders(headerName)) {
                            attachment.addHeader(headerName, headerValue);
                        }
                    }
                    DefaultAttachmentMessage am = new DefaultAttachmentMessage(message);
                    am.addAttachmentObject(part.getName(), (Attachment)attachment);
                    String name = part.getSubmittedFileName();
                    DataHandler value = am.getAttachment(name);
                    Map headers = message.getHeaders();
                    if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, (Object)value, message.getExchange()) || name == null) continue;
                    HttpHelper.appendHeader((Map)headers, (String)name, (Object)value);
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot populate attachments", (Throwable)e);
            }
        }
    }

    protected void populateRequestParameters(HttpServletRequest request, Message message) {
        Map headers = message.getHeaders();
        DefaultAttachmentMessage am = new DefaultAttachmentMessage(message);
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (am.getAttachment(name) != null) {
                DataHandler dh;
                Object value = dh = am.getAttachment(name);
                if (dh.getContentType() == null || dh.getContentType().startsWith("text/plain")) {
                    value = request.getParameter(name);
                }
                if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, value, message.getExchange())) continue;
                HttpHelper.appendHeader((Map)headers, (String)name, (Object)value);
                continue;
            }
            String[] values = request.getParameterValues(name);
            if (LOG.isTraceEnabled()) {
                LOG.trace("HTTP parameter {} = {}", (Object)name, (Object)HttpHelper.sanitizeLog((String[])values));
            }
            if (values == null) continue;
            for (String value : values) {
                if (this.getHeaderFilterStrategy() == null || this.getHeaderFilterStrategy().applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                HttpHelper.appendHeader((Map)headers, (String)name, (Object)value);
            }
        }
    }

    static final class PartDataSource
    implements DataSource {
        private final Part part;

        PartDataSource(Part part) {
            this.part = part;
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public String getName() {
            return this.part.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        public String getContentType() {
            return this.part.getContentType();
        }
    }
}

