/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Issue;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewIssuesConsumer
extends AbstractJiraConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(NewIssuesConsumer.class);
    private final String jql;
    private long latestIssueId = -1L;

    public NewIssuesConsumer(JiraEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.jql = endpoint.getJql() + " ORDER BY key desc";
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.latestIssueId = this.findLatestIssueId();
    }

    protected long findLatestIssueId() {
        try {
            List<Issue> issues = this.getIssues(this.jql, 0, 1, 1);
            if (!issues.isEmpty()) {
                return issues.get(0).getId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    protected int doPoll() throws Exception {
        List<Issue> newIssues = this.getNewIssues();
        for (int i = newIssues.size() - 1; i > -1; --i) {
            Issue newIssue = newIssues.get(i);
            Exchange e = this.createExchange(true);
            e.getIn().setBody((Object)newIssue);
            this.getProcessor().process(e);
        }
        return newIssues.size();
    }

    private List<Issue> getNewIssues() {
        List<Issue> issues;
        Object jqlFilter = this.latestIssueId > -1L ? "id > " + this.latestIssueId + " AND " + this.jql : this.jql;
        try {
            issues = this.getIssues((String)jqlFilter, 0, 50, this.getEndpoint().getMaxResults());
        }
        catch (RestClientException e) {
            String msg;
            int code;
            if (e.getStatusCode().isPresent() && (code = ((Integer)e.getStatusCode().get()).intValue()) == 400 && (msg = e.getMessage()) != null && msg.contains("does not exist for the field 'id'")) {
                LOG.warn("Last issue id: {} no longer exists (could have been deleted). Will recover by fetching last issue id from JIRA and try again on next poll", (Object)this.latestIssueId);
                this.latestIssueId = this.findLatestIssueId();
                return Collections.emptyList();
            }
            throw e;
        }
        if (!issues.isEmpty()) {
            int last = issues.size() - 1;
            this.latestIssueId = issues.get(last).getId();
        }
        return issues;
    }
}

