/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;

public class AttachFileProducer
extends DefaultProducer {
    public AttachFileProducer(JiraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws InvalidPayloadException {
        String issueKey = (String)exchange.getIn().getHeader("IssueKey", String.class);
        if (issueKey == null) {
            throw new IllegalArgumentException("Missing exchange input header named 'IssueKey', it should specify the issue key to attach a file.");
        }
        InputStream is = null;
        String name = null;
        File file = null;
        Object body = exchange.getIn().getBody();
        if (body instanceof File) {
            file = (File)body;
        } else {
            WrappedFile wf = (WrappedFile)exchange.getIn().getBody(WrappedFile.class);
            if (wf != null && wf.getFile() instanceof File) {
                file = (File)wf.getFile();
            }
        }
        if (file == null) {
            is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
            name = (String)exchange.getIn().getHeader("CamelFileName", (Object)exchange.getMessage().getMessageId(), String.class);
        }
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        IssueRestClient issueClient = client.getIssueClient();
        Issue issue = (Issue)issueClient.getIssue(issueKey).claim();
        URI attachmentsUri = issue.getAttachmentsUri();
        if (file != null) {
            issueClient.addAttachments(attachmentsUri, new File[]{file});
        } else {
            issueClient.addAttachment(attachmentsUri, is, name);
        }
    }
}

