/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.jms.RuntimeJmsException;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsBinding {
    private static final transient Log LOG = LogFactory.getLog(JmsBinding.class);

    public Object extractBodyFromJms(JmsExchange exchange, javax.jms.Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                return objectMessage.getObject();
            }
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return textMessage.getText();
            }
            if (message instanceof MapMessage) {
                return this.createMapFromMapMessage((MapMessage)message);
            }
            if (message instanceof BytesMessage || message instanceof StreamMessage) {
                return message;
            }
            return null;
        }
        catch (JMSException e) {
            throw new RuntimeJmsException("Failed to extract body due to: " + (Object)((Object)e) + ". Message: " + message, e);
        }
    }

    public javax.jms.Message makeJmsMessage(Exchange exchange, Session session) throws JMSException {
        javax.jms.Message answer = null;
        if (exchange instanceof JmsExchange) {
            JmsExchange jmsExchange = (JmsExchange)exchange;
            answer = jmsExchange.getIn().getJmsMessage();
        }
        if (answer == null) {
            answer = this.createJmsMessage(exchange.getIn().getBody(), session);
            this.appendJmsProperties(answer, exchange);
        }
        return answer;
    }

    public void appendJmsProperties(javax.jms.Message jmsMessage, Exchange exchange) throws JMSException {
        Message in = exchange.getIn();
        Set entries = in.getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerName.startsWith("JMS") && !headerName.startsWith("JMSX")) {
                if (headerName.equals("JMSCorrelationID")) {
                    jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, headerValue));
                    continue;
                }
                if (headerName.equals("JMSCorrelationID")) {
                    jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, headerValue));
                    continue;
                }
                if (headerName.equals("JMSReplyTo")) {
                    jmsMessage.setJMSReplyTo((Destination)ExchangeHelper.convertToType((Exchange)exchange, Destination.class, headerValue));
                    continue;
                }
                if (headerName.equals("JMSType")) {
                    jmsMessage.setJMSType((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, headerValue));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Ignoring JMS header: " + headerName + " with value: " + headerValue));
                continue;
            }
            if (!this.shouldOutputHeader(in, headerName, headerValue)) continue;
            jmsMessage.setObjectProperty(headerName, headerValue);
        }
    }

    protected javax.jms.Message createJmsMessage(Object body, Session session) throws JMSException {
        if (body instanceof String) {
            return session.createTextMessage((String)body);
        }
        if (body instanceof Serializable) {
            return session.createObjectMessage((Serializable)body);
        }
        return session.createMessage();
    }

    public Map<String, Object> createMapFromMapMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Enumeration names = message.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            Object value = message.getObject(name);
            answer.put(name, value);
        }
        return answer;
    }

    protected boolean shouldOutputHeader(Message camelMessage, String headerName, Object headerValue) {
        return headerValue != null;
    }
}

