/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import org.apache.camel.Component;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsConsumer;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.jms.JmsPollingConsumer;
import org.apache.camel.component.jms.JmsProducer;
import org.apache.camel.component.jms.requestor.Requestor;
import org.apache.camel.impl.DefaultEndpoint;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsEndpoint
extends DefaultEndpoint<JmsExchange> {
    private final JmsComponent component;
    private final boolean pubSubDomain;
    private JmsBinding binding;
    private String destination;
    private String selector;
    private JmsConfiguration configuration;
    private Requestor requestor;
    private long requestTimeout = 20000L;

    public JmsEndpoint(String uri, JmsComponent component, String destination, boolean pubSubDomain, JmsConfiguration configuration) {
        super(uri, (Component)component);
        this.component = component;
        this.configuration = configuration;
        this.destination = destination;
        this.pubSubDomain = pubSubDomain;
    }

    public JmsProducer createProducer() throws Exception {
        return new JmsProducer(this);
    }

    public JmsProducer createProducer(JmsOperations template) throws Exception {
        JmsProducer answer = this.createProducer();
        if (template instanceof JmsTemplate) {
            JmsTemplate jmsTemplate = (JmsTemplate)template;
            jmsTemplate.setPubSubDomain(this.pubSubDomain);
            jmsTemplate.setDefaultDestinationName(this.destination);
        }
        answer.setInOnlyTemplate(template);
        return answer;
    }

    public JmsConsumer createConsumer(Processor processor) throws Exception {
        AbstractMessageListenerContainer listenerContainer = this.configuration.createMessageListenerContainer(this);
        return this.createConsumer(processor, listenerContainer);
    }

    public JmsConsumer createConsumer(Processor processor, AbstractMessageListenerContainer listenerContainer) throws Exception {
        listenerContainer.setDestinationName(this.destination);
        listenerContainer.setPubSubDomain(this.pubSubDomain);
        if (this.selector != null) {
            listenerContainer.setMessageSelector(this.selector);
        }
        return new JmsConsumer(this, processor, listenerContainer);
    }

    public PollingConsumer<JmsExchange> createPollingConsumer() throws Exception {
        JmsOperations template = this.createInOnlyTemplate();
        return new JmsPollingConsumer(this, template);
    }

    public JmsExchange createExchange(ExchangePattern pattern) {
        return new JmsExchange(this.getContext(), pattern, this.getBinding());
    }

    public JmsExchange createExchange(Message message) {
        return new JmsExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), message);
    }

    public JmsOperations createInOnlyTemplate() {
        return this.configuration.createInOnlyTemplate(this.pubSubDomain, this.destination);
    }

    public JmsOperations createInOutTemplate() {
        return this.configuration.createInOutTemplate(this.pubSubDomain, this.destination, this.getRequestTimeout());
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JmsBinding();
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public String getDestination() {
        return this.destination;
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean isSingleton() {
        return false;
    }

    public Requestor getRequestor() throws Exception {
        if (this.requestor == null) {
            this.requestor = this.component.getRequestor();
        }
        return this.requestor;
    }

    public void setRequestor(Requestor requestor) {
        this.requestor = requestor;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }
}

