/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryTopicEndpoint;
import org.apache.camel.component.jms.PassThroughJmsKeyFormatStrategy;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.component.jms.requestor.Requestor;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;

public class JmsComponent
extends DefaultComponent
implements ApplicationContextAware,
HeaderFilterStrategyAware {
    private static final transient Log LOG = LogFactory.getLog(JmsComponent.class);
    private static final String DEFAULT_QUEUE_BROWSE_STRATEGY = "org.apache.camel.component.jms.DefaultQueueBrowseStrategy";
    private JmsConfiguration configuration;
    private ApplicationContext applicationContext;
    private Requestor requestor;
    private QueueBrowseStrategy queueBrowseStrategy;
    private boolean attemptedToCreateQueueBrowserStrategy;
    private HeaderFilterStrategy headerFilterStrategy = new JmsHeaderFilterStrategy();

    public JmsComponent() {
    }

    public JmsComponent(CamelContext context) {
        super(context);
    }

    public JmsComponent(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public static JmsComponent jmsComponent() {
        return new JmsComponent();
    }

    public static JmsComponent jmsComponent(JmsConfiguration configuration) {
        return new JmsComponent(configuration);
    }

    public static JmsComponent jmsComponent(ConnectionFactory connectionFactory) {
        return JmsComponent.jmsComponent(new JmsConfiguration(connectionFactory));
    }

    public static JmsComponent jmsComponentClientAcknowledge(ConnectionFactory connectionFactory) {
        JmsConfiguration template = new JmsConfiguration(connectionFactory);
        template.setAcknowledgementMode(2);
        return JmsComponent.jmsComponent(template);
    }

    public static JmsComponent jmsComponentAutoAcknowledge(ConnectionFactory connectionFactory) {
        JmsConfiguration template = new JmsConfiguration(connectionFactory);
        template.setAcknowledgementMode(1);
        return JmsComponent.jmsComponent(template);
    }

    public static JmsComponent jmsComponentTransacted(ConnectionFactory connectionFactory) {
        JmsTransactionManager transactionManager = new JmsTransactionManager();
        transactionManager.setConnectionFactory(connectionFactory);
        return JmsComponent.jmsComponentTransacted(connectionFactory, (PlatformTransactionManager)transactionManager);
    }

    public static JmsComponent jmsComponentTransacted(ConnectionFactory connectionFactory, PlatformTransactionManager transactionManager) {
        JmsConfiguration template = new JmsConfiguration(connectionFactory);
        template.setTransactionManager(transactionManager);
        template.setTransacted(true);
        template.setTransactedInOut(true);
        return JmsComponent.jmsComponent(template);
    }

    public JmsConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
            if (this.applicationContext != null) {
                Map beansOfType = this.applicationContext.getBeansOfType(ConnectionFactory.class);
                if (!beansOfType.isEmpty()) {
                    ConnectionFactory cf = (ConnectionFactory)beansOfType.values().iterator().next();
                    this.configuration.setConnectionFactory(cf);
                }
                if (!(beansOfType = this.applicationContext.getBeansOfType(DestinationResolver.class)).isEmpty()) {
                    DestinationResolver destinationResolver = (DestinationResolver)beansOfType.values().iterator().next();
                    this.configuration.setDestinationResolver(destinationResolver);
                }
            }
        }
        return this.configuration;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.getConfiguration().setAcceptMessagesWhileStopping(acceptMessagesWhileStopping);
    }

    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementMode(consumerAcknowledgementMode);
    }

    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementModeName(consumerAcknowledgementMode);
    }

    public void setAutoStartup(boolean autoStartup) {
        this.getConfiguration().setAutoStartup(autoStartup);
    }

    public void setCacheLevel(int cacheLevel) {
        this.getConfiguration().setCacheLevel(cacheLevel);
    }

    public void setCacheLevelName(String cacheName) {
        this.getConfiguration().setCacheLevelName(cacheName);
    }

    public void setClientId(String consumerClientId) {
        this.getConfiguration().setClientId(consumerClientId);
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setConcurrentConsumers(concurrentConsumers);
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.getConfiguration().setConnectionFactory(connectionFactory);
    }

    public void setConsumerType(ConsumerType consumerType) {
        this.getConfiguration().setConsumerType(consumerType);
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.getConfiguration().setDeliveryPersistent(deliveryPersistent);
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.getConfiguration().setDurableSubscriptionName(durableSubscriptionName);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.getConfiguration().setExceptionListener(exceptionListener);
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.getConfiguration().setExplicitQosEnabled(explicitQosEnabled);
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.getConfiguration().setExposeListenerSession(exposeListenerSession);
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.getConfiguration().setIdleTaskExecutionLimit(idleTaskExecutionLimit);
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.getConfiguration().setMaxMessagesPerTask(maxMessagesPerTask);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.getConfiguration().setMessageConverter(messageConverter);
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.getConfiguration().setMessageIdEnabled(messageIdEnabled);
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.getConfiguration().setMessageTimestampEnabled(messageTimestampEnabled);
    }

    public void setAlwaysCopyMessage(boolean alwaysCopyMessage) {
        this.getConfiguration().setAlwaysCopyMessage(alwaysCopyMessage);
    }

    public void setUseMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
        this.getConfiguration().setUseMessageIDAsCorrelationID(useMessageIDAsCorrelationID);
    }

    public void setPriority(int priority) {
        this.getConfiguration().setPriority(priority);
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.getConfiguration().setPubSubNoLocal(pubSubNoLocal);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.getConfiguration().setReceiveTimeout(receiveTimeout);
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.getConfiguration().setRecoveryInterval(recoveryInterval);
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.getConfiguration().setSubscriptionDurable(subscriptionDurable);
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.getConfiguration().setTaskExecutor(taskExecutor);
    }

    public void setTimeToLive(long timeToLive) {
        this.getConfiguration().setTimeToLive(timeToLive);
    }

    public void setTransacted(boolean consumerTransacted) {
        this.getConfiguration().setTransacted(consumerTransacted);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.getConfiguration().setTransactionManager(transactionManager);
    }

    public void setTransactionName(String transactionName) {
        this.getConfiguration().setTransactionName(transactionName);
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.getConfiguration().setTransactionTimeout(transactionTimeout);
    }

    public void setUseVersion102(boolean useVersion102) {
        this.getConfiguration().setUseVersion102(useVersion102);
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.getConfiguration().setJmsOperations(jmsOperations);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.getConfiguration().setDestinationResolver(destinationResolver);
    }

    public synchronized Requestor getRequestor() throws Exception {
        if (this.requestor == null) {
            this.requestor = new Requestor(this.getConfiguration(), this.getScheduledExecutorService());
            this.requestor.start();
        }
        return this.requestor;
    }

    public void setRequestor(Requestor requestor) {
        this.requestor = requestor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public QueueBrowseStrategy getQueueBrowseStrategy() {
        if (this.queueBrowseStrategy == null && !this.attemptedToCreateQueueBrowserStrategy) {
            this.attemptedToCreateQueueBrowserStrategy = true;
            try {
                this.queueBrowseStrategy = JmsComponent.tryCreateDefaultQueueBrowseStrategy(this.getCamelContext());
            }
            catch (Throwable e) {
                LOG.warn((Object)("Could not instantiate the QueueBrowseStrategy are you using Spring 2.0.x by any chance? Error: " + e), e);
            }
        }
        return this.queueBrowseStrategy;
    }

    public void setQueueBrowseStrategy(QueueBrowseStrategy queueBrowseStrategy) {
        this.queueBrowseStrategy = queueBrowseStrategy;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    protected void doStop() throws Exception {
        if (this.requestor != null) {
            this.requestor.stop();
        }
        super.doStop();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        JmsEndpoint endpoint;
        boolean pubSubDomain = false;
        boolean tempDestination = false;
        if (remaining.startsWith("queue:")) {
            pubSubDomain = false;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
        } else if (remaining.startsWith("topic:")) {
            pubSubDomain = true;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("topic:".length()), (char)'/');
        } else if (remaining.startsWith("temp:queue:")) {
            pubSubDomain = false;
            tempDestination = true;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("temp:queue:".length()), (char)'/');
        } else if (remaining.startsWith("temp:topic:")) {
            pubSubDomain = true;
            tempDestination = true;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("temp:topic:".length()), (char)'/');
        }
        String subject = this.convertPathToActualDestination(remaining, parameters);
        JmsConfiguration newConfiguration = this.getConfiguration().copy();
        if (pubSubDomain) {
            endpoint = tempDestination ? new JmsTemporaryTopicEndpoint(uri, this, subject, newConfiguration) : new JmsEndpoint(uri, this, subject, pubSubDomain, newConfiguration);
        } else {
            QueueBrowseStrategy strategy = this.getQueueBrowseStrategy();
            endpoint = tempDestination ? new JmsTemporaryQueueEndpoint(uri, this, subject, newConfiguration, strategy) : new JmsQueueEndpoint(uri, this, subject, newConfiguration, strategy);
        }
        String selector = (String)this.getAndRemoveParameter(parameters, "selector", String.class);
        if (selector != null) {
            endpoint.setSelector(selector);
        }
        String username = (String)this.getAndRemoveParameter(parameters, "username", String.class);
        String password = (String)this.getAndRemoveParameter(parameters, "password", String.class);
        if (username != null && password != null) {
            ConnectionFactory cf = endpoint.getConfiguration().getConnectionFactory();
            UserCredentialsConnectionFactoryAdapter ucfa = new UserCredentialsConnectionFactoryAdapter();
            ucfa.setTargetConnectionFactory(cf);
            ucfa.setPassword(password);
            ucfa.setUsername(username);
            endpoint.getConfiguration().setConnectionFactory((ConnectionFactory)ucfa);
        } else if (username != null || password != null) {
            throw new IllegalArgumentException("The JmsComponent's username or password is null");
        }
        String strategy = (String)this.getAndRemoveParameter(parameters, "jmsKeyFormatStrategy", String.class);
        if (strategy != null) {
            if (this.isReferenceParameter(strategy)) {
                String key = strategy.substring(1);
                endpoint.setJmsKeyFormatStrategy((JmsKeyFormatStrategy)this.lookup(key, JmsKeyFormatStrategy.class));
            } else if ("default".equalsIgnoreCase(strategy)) {
                endpoint.setJmsKeyFormatStrategy(new DefaultJmsKeyFormatStrategy());
            } else if ("passthrough".equalsIgnoreCase(strategy)) {
                endpoint.setJmsKeyFormatStrategy(new PassThroughJmsKeyFormatStrategy());
            } else {
                throw new IllegalArgumentException("Unknown jmsKeyFormatStrategy option: " + strategy);
            }
        }
        this.setProperties(endpoint.getConfiguration(), parameters);
        endpoint.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        return endpoint;
    }

    protected String convertPathToActualDestination(String path, Map parameters) {
        return path;
    }

    protected JmsConfiguration createConfiguration() {
        return new JmsConfiguration();
    }

    protected static QueueBrowseStrategy tryCreateDefaultQueueBrowseStrategy(CamelContext context) {
        Class type = context.getClassResolver().resolveClass(DEFAULT_QUEUE_BROWSE_STRATEGY, JmsComponent.class.getClassLoader());
        if (type == null) {
            LOG.warn((Object)"Could not load class: org.apache.camel.component.jms.DefaultQueueBrowseStrategy maybe you are on Spring 2.0.x?");
            return null;
        }
        return (QueueBrowseStrategy)ObjectHelper.newInstance((Class)type, QueueBrowseStrategy.class);
    }
}

