/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.impl.DefaultExchange;

public class JmsExchange
extends DefaultExchange {
    private JmsBinding binding;

    public JmsExchange(Endpoint endpoint, ExchangePattern pattern, JmsBinding binding) {
        super(endpoint, pattern);
        this.binding = binding;
    }

    public JmsExchange(Endpoint endpoint, ExchangePattern pattern, JmsBinding binding, javax.jms.Message message) {
        this(endpoint, pattern, binding);
        this.setIn((Message)new JmsMessage(message));
    }

    public JmsExchange(DefaultExchange parent, JmsBinding binding) {
        super((Exchange)parent);
        this.binding = binding;
    }

    public JmsMessage getIn() {
        return (JmsMessage)super.getIn();
    }

    public JmsMessage getOut() {
        return (JmsMessage)super.getOut();
    }

    public JmsMessage getOut(boolean lazyCreate) {
        return (JmsMessage)super.getOut(lazyCreate);
    }

    public JmsMessage getFault() {
        return (JmsMessage)super.getFault();
    }

    public JmsMessage getFault(boolean lazyCreate) {
        return (JmsMessage)super.getFault(lazyCreate);
    }

    public JmsBinding getBinding() {
        return this.binding;
    }

    public Exchange newInstance() {
        return new JmsExchange(this, this.binding);
    }

    public javax.jms.Message getInMessage() {
        return this.getIn().getJmsMessage();
    }

    public javax.jms.Message getOutMessage() {
        return this.getOut().getJmsMessage();
    }

    public javax.jms.Message getFaultMessage() {
        return this.getFault().getJmsMessage();
    }

    protected JmsMessage createInMessage() {
        return new JmsMessage();
    }

    protected JmsMessage createOutMessage() {
        return new JmsMessage();
    }

    protected Message createFaultMessage() {
        return new JmsMessage();
    }
}

