/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.requestor.DeferredRequestReplyMap;
import org.apache.camel.component.jms.requestor.PersistentReplyToRequestor;
import org.apache.camel.component.jms.requestor.Requestor;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.UuidGenerator;
import org.apache.camel.util.ValueHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;

public class JmsProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(JmsProducer.class);
    private RequestorAffinity affinity;
    private final JmsEndpoint endpoint;
    private JmsOperations inOnlyTemplate;
    private JmsOperations inOutTemplate;
    private UuidGenerator uuidGenerator;
    private DeferredRequestReplyMap deferredRequestReplyMap;
    private Requestor requestor;
    private AtomicBoolean started = new AtomicBoolean(false);

    public JmsProducer(JmsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        JmsConfiguration c = endpoint.getConfiguration();
        this.affinity = RequestorAffinity.PER_PRODUCER;
        if (c.getReplyTo() != null) {
            if (c.getReplyToTempDestinationAffinity().equals("endpoint")) {
                this.affinity = RequestorAffinity.PER_ENDPOINT;
            } else if (c.getReplyToTempDestinationAffinity().equals("component")) {
                this.affinity = RequestorAffinity.PER_COMPONENT;
            }
        }
    }

    public long getRequestTimeout() {
        return this.endpoint.getConfiguration().getRequestTimeout();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAndSetRequestor() throws RuntimeCamelException {
        if (!this.started.get()) {
            JmsProducer jmsProducer = this;
            synchronized (jmsProducer) {
                if (this.started.get()) {
                    return;
                }
                try {
                    JmsConfiguration c = this.endpoint.getConfiguration();
                    if (c.getReplyTo() != null) {
                        this.requestor = new PersistentReplyToRequestor(this.endpoint.getConfiguration(), this.endpoint.getScheduledExecutorService());
                        this.requestor.start();
                    } else if (this.affinity == RequestorAffinity.PER_PRODUCER) {
                        this.requestor = new Requestor(this.endpoint.getConfiguration(), this.endpoint.getScheduledExecutorService());
                        this.requestor.start();
                    } else if (this.affinity == RequestorAffinity.PER_ENDPOINT) {
                        this.requestor = this.endpoint.getRequestor();
                    } else if (this.affinity == RequestorAffinity.PER_COMPONENT) {
                        this.requestor = ((JmsComponent)this.endpoint.getComponent()).getRequestor();
                    }
                }
                catch (Exception e) {
                    throw new FailedToCreateProducerException((Endpoint)this.endpoint, (Throwable)e);
                }
                this.deferredRequestReplyMap = this.requestor.getDeferredRequestReplyMap(this);
                this.started.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAndUnsetRequestor() throws Exception {
        if (this.started.get()) {
            JmsProducer jmsProducer = this;
            synchronized (jmsProducer) {
                if (!this.started.get()) {
                    return;
                }
                this.requestor.removeDeferredRequestReplyMap(this);
                if (this.affinity == RequestorAffinity.PER_PRODUCER) {
                    this.requestor.stop();
                }
                this.started.set(false);
            }
        }
    }

    protected void doStop() throws Exception {
        this.testAndUnsetRequestor();
        super.doStop();
    }

    public void process(final Exchange exchange) {
        block34: {
            final Message in = exchange.getIn();
            String destinationName = this.endpoint.getDestinationName();
            Destination destination = (Destination)exchange.getProperty("JMSDestination", Destination.class);
            if (destination == null) {
                destination = this.endpoint.getDestination();
            }
            if (exchange.getPattern().isOutCapable()) {
                this.testAndSetRequestor();
                final Destination replyTo = this.requestor.getReplyTo();
                if (replyTo == null) {
                    throw new RuntimeExchangeException("Failed to resolve replyTo destination", exchange);
                }
                final boolean msgIdAsCorrId = this.endpoint.getConfiguration().isUseMessageIDAsCorrelationID();
                String correlationId = (String)in.getHeader("JMSCorrelationID", String.class);
                if (correlationId == null && !msgIdAsCorrId) {
                    in.setHeader("JMSCorrelationID", (Object)this.getUuidGenerator().generateId());
                }
                final ValueHolder futureHolder = new ValueHolder();
                final DeferredRequestReplyMap.DeferredMessageSentCallback callback = msgIdAsCorrId ? this.deferredRequestReplyMap.createDeferredMessageSentCallback() : null;
                MessageCreator messageCreator = new MessageCreator(){

                    public javax.jms.Message createMessage(Session session) throws JMSException {
                        javax.jms.Message message = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
                        message.setJMSReplyTo(replyTo);
                        JmsProducer.this.requestor.setReplyToSelectorHeader(in, message);
                        FutureTask future = !msgIdAsCorrId ? JmsProducer.this.requestor.getReceiveFuture(message.getJMSCorrelationID(), JmsProducer.this.endpoint.getConfiguration().getRequestTimeout()) : JmsProducer.this.requestor.getReceiveFuture(callback);
                        futureHolder.set((Object)future);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)((Object)((Object)JmsProducer.this.endpoint) + " sending JMS message: " + message));
                        }
                        return message;
                    }
                };
                JmsConfiguration.CamelJmsTemplate template = null;
                JmsConfiguration.CamelJmsTeemplate102 template102 = null;
                if (this.endpoint.isUseVersion102()) {
                    template102 = (JmsConfiguration.CamelJmsTeemplate102)this.getInOutTemplate();
                } else {
                    template = (JmsConfiguration.CamelJmsTemplate)this.getInOutTemplate();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Using JMS API " + (this.endpoint.isUseVersion102() ? "v1.0.2" : "v1.1")));
                }
                if (destinationName != null) {
                    if (template != null) {
                        template.send(destinationName, messageCreator, (JmsConfiguration.MessageSentCallback)callback);
                    } else {
                        template102.send(destinationName, messageCreator, (JmsConfiguration.MessageSentCallback)callback);
                    }
                } else if (destination != null) {
                    if (template != null) {
                        template.send(destination, messageCreator, (JmsConfiguration.MessageSentCallback)callback);
                    } else {
                        template102.send(destination, messageCreator, (JmsConfiguration.MessageSentCallback)callback);
                    }
                } else {
                    throw new IllegalArgumentException("Neither destination nor destinationName is specified on this endpoint: " + (Object)((Object)this.endpoint));
                }
                this.setMessageId(exchange);
                long requestTimeout = this.endpoint.getConfiguration().getRequestTimeout();
                try {
                    javax.jms.Message message;
                    block33: {
                        message = null;
                        try {
                            message = requestTimeout < 0L ? (javax.jms.Message)((FutureTask)futureHolder.get()).get() : (javax.jms.Message)((FutureTask)futureHolder.get()).get(requestTimeout, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Future interupted: " + e), (Throwable)e);
                            }
                        }
                        catch (TimeoutException e) {
                            if (!LOG.isDebugEnabled()) break block33;
                            LOG.debug((Object)("Future timed out: " + e), (Throwable)e);
                        }
                    }
                    if (message != null) {
                        JmsMessage response = new JmsMessage(message, this.endpoint.getBinding());
                        Object body = response.getBody();
                        if (this.endpoint.isTransferException() && body instanceof Exception) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Reply recieved. Setting reply as Exception: " + body));
                            }
                            exchange.setException((Exception)body);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Reply recieved. Setting reply as OUT message: " + body));
                            }
                            exchange.setOut((Message)response);
                        }
                        if (correlationId != null) {
                            message.setJMSCorrelationID(correlationId);
                            exchange.getOut().setHeader("JMSCorrelationID", (Object)correlationId);
                        }
                        break block34;
                    }
                    exchange.setException((Exception)new ExchangeTimedOutException(exchange, requestTimeout));
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
            } else {
                Object replyTo;
                if (!this.endpoint.isPreserveMessageQos() && !this.endpoint.isExplicitQosEnabled() && (replyTo = exchange.getIn().getHeader("JMSReplyTo")) != null) {
                    String to = destinationName != null ? destinationName : "" + destination;
                    LOG.warn((Object)("Disabling JMSReplyTo as this Exchange is not OUT capable with JMSReplyTo: " + replyTo + " to destination: " + to + " for Exchange: " + exchange));
                    exchange.getIn().setHeader("JMSReplyTo", null);
                }
                MessageCreator messageCreator = new MessageCreator(){

                    public javax.jms.Message createMessage(Session session) throws JMSException {
                        javax.jms.Message message = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)((Object)((Object)JmsProducer.this.endpoint) + " sending JMS message: " + message));
                        }
                        return message;
                    }
                };
                if (destination != null) {
                    this.getInOnlyTemplate().send(destination, messageCreator);
                } else if (destinationName != null) {
                    this.getInOnlyTemplate().send(destinationName, messageCreator);
                } else {
                    throw new IllegalArgumentException("Neither destination nor destinationName is specified on this endpoint: " + (Object)((Object)this.endpoint));
                }
                this.setMessageId(exchange);
            }
        }
    }

    protected void setMessageId(Exchange exchange) {
        if (!(exchange instanceof JmsExchange)) {
            return;
        }
        try {
            JmsExchange jmsExchange = (JmsExchange)((Object)JmsExchange.class.cast(exchange));
            if (jmsExchange.hasOut()) {
                JmsMessage out = jmsExchange.getOut();
                out.setMessageId(out.getJmsMessage().getJMSMessageID());
            }
        }
        catch (JMSException e) {
            LOG.warn((Object)"Unable to retrieve JMSMessageID from outgoing JMS Message and set it into Camel's MessageId", (Throwable)e);
        }
    }

    public JmsOperations getInOnlyTemplate() {
        if (this.inOnlyTemplate == null) {
            this.inOnlyTemplate = this.endpoint.createInOnlyTemplate();
        }
        return this.inOnlyTemplate;
    }

    public void setInOnlyTemplate(JmsOperations inOnlyTemplate) {
        this.inOnlyTemplate = inOnlyTemplate;
    }

    public JmsOperations getInOutTemplate() {
        if (this.inOutTemplate == null) {
            this.inOutTemplate = this.endpoint.createInOutTemplate();
        }
        return this.inOutTemplate;
    }

    public void setInOutTemplate(JmsOperations inOutTemplate) {
        this.inOutTemplate = inOutTemplate;
    }

    public UuidGenerator getUuidGenerator() {
        if (this.uuidGenerator == null) {
            this.uuidGenerator = new UuidGenerator();
        }
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RequestorAffinity {
        PER_COMPONENT(0),
        PER_ENDPOINT(1),
        PER_PRODUCER(2);

        private int value;

        private RequestorAffinity(int value) {
            this.value = value;
        }
    }
}

