/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.Executor;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.DefaultSpringErrorHandler;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.ReplyManagerSupport;
import org.apache.camel.component.jms.reply.TemporaryQueueReplyHandler;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.destination.DestinationResolver;

public class TemporaryQueueReplyManager
extends ReplyManagerSupport {
    public TemporaryQueueReplyManager(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public String registerReply(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        TemporaryQueueReplyHandler handler = new TemporaryQueueReplyHandler(this, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
        this.correlation.put(correlationId, handler, requestTimeout);
        return correlationId;
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        this.log.trace("Updated provisional correlationId [{}] to expected correlationId [{}]", (Object)correlationId, (Object)newCorrelationId);
        ReplyHandler handler = this.correlation.remove(correlationId);
        if (handler != null) {
            this.correlation.put(newCorrelationId, handler, requestTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleReplyMessage(String correlationID, javax.jms.Message message) {
        ReplyHandler handler = (ReplyHandler)this.correlation.get(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            try {
                handler.onReply(correlationID, message);
            }
            finally {
                this.correlation.remove(correlationID);
            }
        } else {
            this.log.warn("Reply received for unknown correlationID [{}]. The message will be ignored: {}", (Object)correlationID, (Object)message);
        }
    }

    @Override
    public void setReplyToSelectorHeader(Message camelMessage, javax.jms.Message jmsMessage) throws JMSException {
    }

    @Override
    protected AbstractMessageListenerContainer createListenerContainer() throws Exception {
        DefaultJmsMessageListenerContainer answer = new DefaultJmsMessageListenerContainer(this.endpoint);
        answer.setDestinationName("temporary");
        answer.setDestinationResolver(new DestinationResolver(){

            public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
                TemporaryQueue queue = session.createTemporaryQueue();
                TemporaryQueueReplyManager.this.setReplyTo((Destination)queue);
                return queue;
            }
        });
        answer.setAutoStartup(true);
        if (this.endpoint.getMaxMessagesPerTask() >= 0) {
            answer.setMaxMessagesPerTask(this.endpoint.getMaxMessagesPerTask());
        }
        answer.setIdleConsumerLimit(this.endpoint.getIdleConsumerLimit());
        answer.setIdleTaskExecutionLimit(this.endpoint.getIdleTaskExecutionLimit());
        answer.setMessageListener(this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(this.endpoint.getConcurrentConsumers());
        if (this.endpoint.getMaxConcurrentConsumers() > 0) {
            answer.setMaxConcurrentConsumers(this.endpoint.getMaxConcurrentConsumers());
        }
        answer.setConnectionFactory(this.endpoint.getConnectionFactory());
        String clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = clientId + ".CamelReplyManager";
            answer.setClientId(clientId);
        }
        answer.setSessionTransacted(false);
        if (this.endpoint.getExceptionListener() != null) {
            answer.setExceptionListener(this.endpoint.getExceptionListener());
        }
        if (this.endpoint.getErrorHandler() != null) {
            answer.setErrorHandler(this.endpoint.getErrorHandler());
        } else {
            answer.setErrorHandler(new DefaultSpringErrorHandler(TemporaryQueueReplyManager.class, this.endpoint.getErrorHandlerLoggingLevel(), this.endpoint.isErrorHandlerLogStackTrace()));
        }
        if (this.endpoint.getReceiveTimeout() >= 0L) {
            answer.setReceiveTimeout(this.endpoint.getReceiveTimeout());
        }
        if (this.endpoint.getRecoveryInterval() >= 0L) {
            answer.setRecoveryInterval(this.endpoint.getRecoveryInterval());
        }
        if (this.endpoint.getTaskExecutor() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using custom TaskExecutor: {} on listener container: {}", (Object)this.endpoint.getTaskExecutor(), (Object)answer);
            }
            answer.setTaskExecutor((Executor)this.endpoint.getTaskExecutor());
        }
        String name = "TemporaryQueueReplyManager[" + answer.getDestinationName() + "]";
        answer.setBeanName(name);
        if (answer.getConcurrentConsumers() > 1) {
            this.log.info("Using {}-{} concurrent consumers on {}", new Object[]{answer.getConcurrentConsumers(), answer.getMaxConcurrentConsumers(), name});
        }
        return answer;
    }
}

