/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.ScheduledExecutorService;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.reply.CorrelationMap;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyHolder;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

public abstract class ReplyManagerSupport
extends ServiceSupport
implements ReplyManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected ScheduledExecutorService executorService;
    protected JmsEndpoint endpoint;
    protected Destination replyTo;
    protected AbstractMessageListenerContainer listenerContainer;
    protected long replyToResolverTimeout = 5000L;
    protected CorrelationMap correlation;

    public void setScheduledExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setEndpoint(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setReplyTo(Destination replyTo) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("ReplyTo destination: " + replyTo));
        }
        this.replyTo = replyTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getReplyTo() {
        ReplyManagerSupport replyManagerSupport = this;
        synchronized (replyManagerSupport) {
            try {
                if (this.replyTo == null) {
                    this.wait(this.replyToResolverTimeout);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.replyTo;
    }

    public void onMessage(javax.jms.Message message) {
        String correlationID = null;
        try {
            correlationID = message.getJMSCorrelationID();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (correlationID == null) {
            this.log.warn((Object)("Ignoring message with no correlationID: " + message));
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received reply message with correlationID: " + correlationID + " -> " + message));
        }
        this.handleReplyMessage(correlationID, message);
    }

    public void processReply(ReplyHolder holder) {
        if (holder != null && this.isRunAllowed()) {
            Exchange exchange = holder.getExchange();
            javax.jms.Message message = holder.getMessage();
            boolean timeout = holder.isTimeout();
            if (timeout) {
                exchange.setException((Throwable)new ExchangeTimedOutException(exchange, holder.getRequestTimeout()));
            } else {
                JmsMessage response = new JmsMessage(message, this.endpoint.getBinding());
                Object body = response.getBody();
                if (this.endpoint.isTransferException() && body instanceof Exception) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Reply received. Setting reply as an Exception: " + body));
                    }
                    exchange.setException((Throwable)((Exception)body));
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Reply received. Setting reply as OUT message: " + body));
                    }
                    exchange.setOut((Message)response);
                }
                if (holder.getOriginalCorrelationId() != null) {
                    JmsMessageHelper.setCorrelationId(message, holder.getOriginalCorrelationId());
                    exchange.getOut().setHeader("JMSCorrelationID", (Object)holder.getOriginalCorrelationId());
                }
            }
            AsyncCallback callback = holder.getCallback();
            callback.done(false);
        }
    }

    protected abstract void handleReplyMessage(String var1, javax.jms.Message var2);

    protected abstract AbstractMessageListenerContainer createListenerContainer() throws Exception;

    protected ReplyHandler waitForProvisionCorrelationToBeUpdated(String correlationID, javax.jms.Message message) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Early reply received with correlationID [" + correlationID + "] -> " + message));
        }
        ReplyHandler answer = null;
        boolean done = false;
        int counter = 0;
        while (!done && counter++ < 50) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Early reply not found handler at attempt " + counter + ". Waiting a bit longer."));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            answer = (ReplyHandler)this.correlation.get(correlationID);
            boolean bl = done = answer != null;
            if (answer == null || !this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("Early reply with correlationID [" + correlationID + "] has been matched after " + counter + " attempts and can be processed using handler: " + answer));
        }
        return answer;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.executorService, (String)"executorService", (Object)this);
        ObjectHelper.notNull((Object)((Object)this.endpoint), (String)"endpoint", (Object)this);
        this.correlation = new CorrelationMap(this.executorService, 1000L);
        ServiceHelper.startService((Object)((Object)this.correlation));
        this.listenerContainer = this.createListenerContainer();
        this.listenerContainer.afterPropertiesSet();
        this.listenerContainer.start();
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)((Object)this.correlation));
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
            this.listenerContainer.destroy();
            this.listenerContainer = null;
        }
    }
}

