/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.Executor;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.ReplyManagerSupport;
import org.apache.camel.component.jms.reply.TemporaryQueueReplyHandler;
import org.apache.camel.component.jms.reply.UnknownReplyMessageException;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.destination.DestinationResolver;

public class TemporaryQueueReplyManager
extends ReplyManagerSupport {
    public String registerReply(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        TemporaryQueueReplyHandler handler = new TemporaryQueueReplyHandler(this, exchange, callback, originalCorrelationId, requestTimeout);
        this.correlation.put(correlationId, handler, requestTimeout);
        return correlationId;
    }

    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Updated provisional correlationId [" + correlationId + "] to expected correlationId [" + newCorrelationId + "]"));
        }
        ReplyHandler handler = (ReplyHandler)this.correlation.remove(correlationId);
        this.correlation.put(newCorrelationId, handler, requestTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReplyMessage(String correlationID, javax.jms.Message message) {
        ReplyHandler handler = (ReplyHandler)this.correlation.get(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            try {
                handler.onReply(correlationID, message);
            }
            finally {
                this.correlation.remove(correlationID);
            }
        } else {
            String text = "Reply received for unknown correlationID [" + correlationID + "] -> " + message;
            this.log.warn((Object)text);
            throw new UnknownReplyMessageException(text, message, correlationID);
        }
    }

    public void setReplyToSelectorHeader(Message camelMessage, javax.jms.Message jmsMessage) throws JMSException {
    }

    protected AbstractMessageListenerContainer createListenerContainer() throws Exception {
        ExceptionListener exceptionListener;
        TaskExecutor taskExecutor;
        DefaultMessageListenerContainer answer = new DefaultMessageListenerContainer();
        answer.setDestinationName("temporary");
        answer.setDestinationResolver(new DestinationResolver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
                TemporaryQueue queue = null;
                TemporaryQueueReplyManager temporaryQueueReplyManager = TemporaryQueueReplyManager.this;
                synchronized (temporaryQueueReplyManager) {
                    try {
                        queue = session.createTemporaryQueue();
                        TemporaryQueueReplyManager.this.setReplyTo((Destination)queue);
                    }
                    finally {
                        TemporaryQueueReplyManager.this.notifyAll();
                    }
                }
                return queue;
            }
        });
        answer.setAutoStartup(true);
        answer.setMessageListener((Object)this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(1);
        answer.setConnectionFactory(this.endpoint.getConnectionFactory());
        answer.setSessionTransacted(false);
        String clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = clientId + ".CamelReplyManager";
            answer.setClientId(clientId);
        }
        if ((taskExecutor = this.endpoint.getTaskExecutor()) != null) {
            answer.setTaskExecutor((Executor)taskExecutor);
        }
        if ((exceptionListener = this.endpoint.getExceptionListener()) != null) {
            answer.setExceptionListener(exceptionListener);
        }
        return answer;
    }
}

